/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.utils;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ProviderPropertiesResolver {
    public static String resolveGroup(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String group = ProviderPropertiesResolver.isDefaultGroup(annotation.serviceGroup()) ? properties.getGroup() : annotation.serviceGroup();
        String specific = ProviderPropertiesResolver.findValue(serviceInterface, properties.getGroups());
        return ProviderPropertiesResolver.isEmpty(specific) ? group : specific;
    }

    public static String resolveVersion(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String version = ProviderPropertiesResolver.isDefaultVersion(annotation.serviceVersion()) ? properties.getVersion() : annotation.serviceVersion();
        String specific = ProviderPropertiesResolver.findValue(serviceInterface, properties.getVersions());
        return ProviderPropertiesResolver.isEmpty(specific) ? version : specific;
    }

    public static Object resolveTimeout(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String timeoutString;
        int timeout = annotation.clientTimeout();
        if (annotation.clientTimeout() < 0 && properties.getTimeout() != null) {
            timeout = properties.getTimeout();
        }
        if (ProviderPropertiesResolver.isEmpty(timeoutString = ProviderPropertiesResolver.findValue(serviceInterface, properties.getTimeouts()))) {
            timeoutString = annotation.clientTimeoutStr();
        }
        if (StringUtils.hasText((String)timeoutString)) {
            return timeoutString;
        }
        if (timeout > 0) {
            return timeout;
        }
        return null;
    }

    public static String resolveConfigserverCenter(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String configServerCenters = null;
        if (!ProviderPropertiesResolver.isEmpty(properties.getConfigserverCenter())) {
            configServerCenters = properties.getConfigserverCenter();
        } else if (!ProviderPropertiesResolver.isEmpty(properties.getRegions())) {
            configServerCenters = properties.getRegions();
        }
        String specialConfigServerCenters = ProviderPropertiesResolver.findValue(serviceInterface, properties.getConfigserverCenters());
        if (ProviderPropertiesResolver.isEmpty(specialConfigServerCenters)) {
            if (annotation.configServerCenters() != null && annotation.configServerCenters().length > 0) {
                configServerCenters = StringUtils.arrayToCommaDelimitedString((Object[])annotation.configServerCenters());
            }
        } else {
            configServerCenters = specialConfigServerCenters;
        }
        return configServerCenters;
    }

    public static Object resolveDelayPublish(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String delayPublish = System.getProperty("hsf.publish.delayed");
        if (ProviderPropertiesResolver.isEmpty(delayPublish) && ProviderPropertiesResolver.isEmpty(delayPublish = properties.getDelayPublish())) {
            delayPublish = ProviderPropertiesResolver.findValue(serviceInterface, properties.getDelayPublishes());
        }
        return ProviderPropertiesResolver.isEmpty(delayPublish) ? Boolean.valueOf(annotation.delayedPublish()) : delayPublish;
    }

    public static Object resolveCorePoolSize(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String corePoolSize = ProviderPropertiesResolver.findValue(serviceInterface, properties.getCorePoolSizes());
        if (ProviderPropertiesResolver.isEmpty(corePoolSize)) {
            corePoolSize = annotation.corePoolSizeStr();
        }
        return ProviderPropertiesResolver.isEmpty(corePoolSize) ? Integer.valueOf(annotation.corePoolSize()) : corePoolSize;
    }

    public static Object resolveMaxPoolSize(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String maxPoolSize = ProviderPropertiesResolver.findValue(serviceInterface, properties.getMaxPoolSizes());
        if (ProviderPropertiesResolver.isEmpty(maxPoolSize)) {
            maxPoolSize = annotation.maxPoolSizeStr();
        }
        return ProviderPropertiesResolver.isEmpty(maxPoolSize) ? Integer.valueOf(annotation.maxPoolSize()) : maxPoolSize;
    }

    public static String resolveInvokeType(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String invokeType = ProviderPropertiesResolver.findValue(serviceInterface, properties.getInvokeTypes());
        if (ProviderPropertiesResolver.isEmpty(invokeType)) {
            invokeType = annotation.invokeType();
        }
        return ProviderPropertiesResolver.isEmpty(invokeType) ? annotation.invokeType() : invokeType;
    }

    public static String resolveSerializeType(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String serializeType = ProviderPropertiesResolver.findValue(serviceInterface, properties.getSerializeTypes());
        if (ProviderPropertiesResolver.isEmpty(serializeType)) {
            serializeType = annotation.serializeType();
        }
        return ProviderPropertiesResolver.isEmpty(serializeType) ? annotation.serializeType() : serializeType;
    }

    public static String resolveSupportAsynCall(HSFProvider annotation, String serviceInterface, HsfProperties properties) {
        String supportAsynCall = ProviderPropertiesResolver.findValue(serviceInterface, properties.getSupportAsynCalls());
        if (ProviderPropertiesResolver.isEmpty(supportAsynCall)) {
            supportAsynCall = annotation.supportAsynCall();
        }
        return ProviderPropertiesResolver.isEmpty(supportAsynCall) ? annotation.supportAsynCall() : supportAsynCall;
    }

    private static String findValue(String interfaceName, Map<String, String> values) {
        if (values != null && values.containsKey(interfaceName)) {
            return values.get(interfaceName);
        }
        return null;
    }

    private static boolean isDefaultGroup(String group) {
        return "HSF".equals(group);
    }

    private static boolean isDefaultVersion(String version) {
        return "1.0.0.DAILY".equals(version);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

