/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertiesPrefixer;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.configdata.ConfigPreference;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataResource;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.PropertySource;

public class NacosConfigDataLoader
implements ConfigDataLoader<NacosConfigDataResource> {
    private final Log log;

    public NacosConfigDataLoader(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public ConfigData load(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        return this.doLoad(context, resource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        try {
            ConfigService configService = this.getBean(context, NacosConfigManager.class).getConfigService();
            NacosConfigProperties properties = this.getBean(context, NacosConfigProperties.class);
            NacosConfigDataResource.NacosItemConfig config = resource.getConfig();
            List<PropertySource<?>> propertySources = this.pullConfig(configService, config.getGroup(), config.getDataId(), config.getSuffix(), properties.getTimeout());
            NacosPropertySource propertySource = new NacosPropertySource(propertySources, config.getGroup(), config.getDataId(), new Date(), config.isRefreshEnabled());
            NacosPropertySourceRepository.collectNacosPropertySource(propertySource);
            return new ConfigData(propertySources, this.getOptions(context, resource));
        }
        catch (Exception e) {
            this.log.error((Object)("Error getting properties from nacos: " + resource), (Throwable)e);
            if (!resource.isOptional()) {
                throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
            }
            return null;
        }
    }

    private ConfigData.Option[] getOptions(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
        options.add(ConfigData.Option.IGNORE_IMPORTS);
        options.add(ConfigData.Option.IGNORE_PROFILES);
        if (this.getPreference(context, resource) == ConfigPreference.REMOTE) {
            options.add(ConfigData.Option.PROFILE_SPECIFIC);
        }
        return options.toArray(new ConfigData.Option[0]);
    }

    private ConfigPreference getPreference(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        Binder binder = (Binder)context.getBootstrapContext().get(Binder.class);
        String prefix = NacosPropertiesPrefixer.getPrefix(binder);
        ConfigPreference preference = (ConfigPreference)((Object)binder.bind(prefix + ".config.preference", ConfigPreference.class).orElse((Object)ConfigPreference.LOCAL));
        String specificPreference = resource.getConfig().getPreference();
        if (specificPreference != null) {
            try {
                preference = ConfigPreference.valueOf(specificPreference.toUpperCase());
            }
            catch (IllegalArgumentException ignore) {
                this.log.error((Object)String.format("illegal preference value: %s, using default preference: %s", new Object[]{specificPreference, preference}));
            }
        }
        return preference;
    }

    private List<PropertySource<?>> pullConfig(ConfigService configService, String group, String dataId, String suffix, long timeout) throws NacosException, IOException {
        String config = configService.getConfig(dataId, group, timeout);
        this.logLoadInfo(group, dataId, config);
        String configName = group + "@" + dataId;
        return NacosDataParserHandler.getInstance().parseNacosData(configName, config, suffix);
    }

    private void logLoadInfo(String group, String dataId, String config) {
        if (config != null) {
            this.log.info((Object)String.format("[Nacos Config] Load config[dataId=%s, group=%s] success", dataId, group));
        } else {
            this.log.warn((Object)String.format("[Nacos Config] config[dataId=%s, group=%s] is empty", dataId, group));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("[Nacos Config] config[dataId=%s, group=%s] content: \n%s", dataId, group, config));
        }
    }

    protected <T> T getBean(ConfigDataLoaderContext context, Class<T> type) {
        if (context.getBootstrapContext().isRegistered(type)) {
            return (T)context.getBootstrapContext().get(type);
        }
        return null;
    }
}

