/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.refresh.RefreshBehavior;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class SmartConfigurationPropertiesRebinder
extends ConfigurationPropertiesRebinder {
    private Map<String, ConfigurationPropertiesBean> beanMap;
    private ApplicationContext applicationContext;
    private RefreshBehavior refreshBehavior;

    public SmartConfigurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        super(beans);
        this.fillBeanMap(beans);
    }

    private void fillBeanMap(ConfigurationPropertiesBeans beans) {
        this.beanMap = new HashMap<String, ConfigurationPropertiesBean>();
        Field field = ReflectionUtils.findField(beans.getClass(), (String)"beans");
        if (field != null) {
            field.setAccessible(true);
            this.beanMap.putAll(Optional.ofNullable(ReflectionUtils.getField((Field)field, (Object)beans)).orElse(Collections.emptyMap()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
        this.refreshBehavior = (RefreshBehavior)((Object)this.applicationContext.getEnvironment().getProperty("spring.cloud.nacos.config.refresh-behavior", RefreshBehavior.class, (Object)RefreshBehavior.ALL_BEANS));
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.applicationContext.equals(event.getSource()) || event.getKeys().equals(event.getSource())) {
            switch (this.refreshBehavior) {
                case SPECIFIC_BEAN: {
                    this.rebindSpecificBean(event);
                    break;
                }
                default: {
                    this.rebind();
                }
            }
        }
    }

    private void rebindSpecificBean(EnvironmentChangeEvent event) {
        HashSet refreshedSet = new HashSet();
        this.beanMap.forEach((name, bean) -> event.getKeys().forEach(changeKey -> {
            String prefix = AnnotationUtils.getValue((Annotation)bean.getAnnotation()).toString();
            if (changeKey.startsWith(prefix) && refreshedSet.add(name)) {
                this.rebind((String)name);
            }
        }));
    }
}

