/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery.reactive;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.cloud.nacos.discovery.ServiceCache;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class NacosReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosReactiveDiscoveryClient.class);
    private NacosServiceDiscovery serviceDiscovery;
    @Value(value="${spring.cloud.nacos.discovery.failure-tolerance-enabled:false}")
    private boolean failureToleranceEnabled;

    public NacosReactiveDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        this.serviceDiscovery = nacosServiceDiscovery;
    }

    public String description() {
        return "Spring Cloud Nacos Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Mono.justOrEmpty((Object)serviceId).flatMapMany(this.loadInstancesFromNacos()).subscribeOn(Schedulers.boundedElastic());
    }

    private Function<String, Publisher<ServiceInstance>> loadInstancesFromNacos() {
        return serviceId -> {
            try {
                return Mono.justOrEmpty(this.serviceDiscovery.getInstances((String)serviceId)).flatMapMany(instances -> {
                    ServiceCache.setInstances(serviceId, instances);
                    return Flux.fromIterable((Iterable)instances);
                });
            }
            catch (NacosException e) {
                log.error("get service instance[{}] from nacos error!", serviceId, (Object)e);
                return this.failureToleranceEnabled ? Flux.fromIterable(ServiceCache.getInstances(serviceId)) : Flux.empty();
            }
        };
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            try {
                return Mono.justOrEmpty(this.serviceDiscovery.getServices()).flatMapMany(services -> {
                    ServiceCache.set(services);
                    return Flux.fromIterable((Iterable)services);
                });
            }
            catch (Exception e) {
                log.error("get services from nacos server fail,", (Throwable)e);
                return this.failureToleranceEnabled ? Flux.fromIterable(ServiceCache.get()) : Flux.empty();
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

