/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.adapter.spring.webflux.SentinelWebFluxFilter;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import com.alibaba.csp.sentinel.adapter.spring.webflux.exception.SentinelBlockExceptionHandler;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={SentinelReactorTransformer.class})
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelWebFluxAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SentinelWebFluxAutoConfiguration.class);
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;
    @Autowired
    private Optional<BlockRequestHandler> blockRequestHandler;

    public SentinelWebFluxAutoConfiguration(ObjectProvider<List<ViewResolver>> viewResolvers, ServerCodecConfigurer serverCodecConfigurer) {
        this.viewResolvers = (List)viewResolvers.getIfAvailable(Collections::emptyList);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    @PostConstruct
    public void init() {
        this.blockRequestHandler.ifPresent(WebFluxCallbackManager::setBlockHandler);
    }

    @Bean
    @Order(value=-2)
    @ConditionalOnProperty(name={"spring.cloud.sentinel.filter.enabled"}, matchIfMissing=true)
    public SentinelBlockExceptionHandler sentinelBlockExceptionHandler() {
        return new SentinelBlockExceptionHandler(this.viewResolvers, this.serverCodecConfigurer);
    }

    @Bean
    @Order(value=-1)
    @ConditionalOnProperty(name={"spring.cloud.sentinel.filter.enabled"}, matchIfMissing=true)
    public SentinelWebFluxFilter sentinelWebFluxFilter() {
        log.info("[Sentinel Starter] register Sentinel SentinelWebFluxFilter");
        return new SentinelWebFluxFilter();
    }
}

