/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterMetricBucket;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetricLeapArray;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;

public class ClusterMetric {
    private final ClusterMetricLeapArray metric;

    public ClusterMetric(int sampleCount, int intervalInMs) {
        AssertUtil.isTrue((sampleCount > 0 ? 1 : 0) != 0, (String)"sampleCount should be positive");
        AssertUtil.isTrue((intervalInMs > 0 ? 1 : 0) != 0, (String)"interval should be positive");
        AssertUtil.isTrue((intervalInMs % sampleCount == 0 ? 1 : 0) != 0, (String)"time span needs to be evenly divided");
        this.metric = new ClusterMetricLeapArray(sampleCount, intervalInMs);
    }

    public void add(ClusterFlowEvent event, long count) {
        ((ClusterMetricBucket)this.metric.currentWindow().value()).add(event, count);
    }

    public long getCurrentCount(ClusterFlowEvent event) {
        return ((ClusterMetricBucket)this.metric.currentWindow().value()).get(event);
    }

    public long getSum(ClusterFlowEvent event) {
        this.metric.currentWindow();
        long sum = 0L;
        List buckets = this.metric.values();
        for (ClusterMetricBucket bucket : buckets) {
            sum += bucket.get(event);
        }
        return sum;
    }

    public double getAvg(ClusterFlowEvent event) {
        return (double)this.getSum(event) / this.metric.getIntervalInSecond();
    }

    public int tryOccupyNext(ClusterFlowEvent event, int acquireCount, double threshold) {
        double latestQps = this.getAvg(ClusterFlowEvent.PASS);
        if (!this.canOccupy(event, acquireCount, latestQps, threshold)) {
            return 0;
        }
        this.metric.addOccupyPass(acquireCount);
        this.add(ClusterFlowEvent.WAITING, acquireCount);
        return 1000 / this.metric.getSampleCount();
    }

    private boolean canOccupy(ClusterFlowEvent event, int acquireCount, double latestQps, double threshold) {
        long headPass = this.metric.getFirstCountOfWindow(event);
        long occupiedCount = this.metric.getOccupiedCount(event);
        return latestQps + (double)((long)acquireCount + occupiedCount) - (double)headPass <= threshold;
    }
}

