/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster;

import com.alibaba.csp.sentinel.cluster.ClusterTokenClient;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.ServiceLoader;

public final class TokenClientProvider {
    private static ClusterTokenClient client = null;
    private static final ServiceLoader<ClusterTokenClient> LOADER = ServiceLoader.load(ClusterTokenClient.class);

    public static ClusterTokenClient getClient() {
        return client;
    }

    private static void resolveTokenClientInstance() {
        ArrayList<ClusterTokenClient> clients = new ArrayList<ClusterTokenClient>();
        for (ClusterTokenClient client : LOADER) {
            clients.add(client);
        }
        if (!clients.isEmpty()) {
            client = (ClusterTokenClient)clients.get(0);
            RecordLog.info("[TokenClientProvider] Token client resolved: " + client.getClass().getCanonicalName(), new Object[0]);
        } else {
            RecordLog.warn("[TokenClientProvider] No existing token client, resolve failed", new Object[0]);
        }
    }

    private TokenClientProvider() {
    }

    static {
        TokenClientProvider.resolveTokenClientInstance();
    }
}

