/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.context;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.Node;

public class Context {
    private final String name;
    private DefaultNode entranceNode;
    private Entry curEntry;
    private String origin = "";
    private final boolean async;

    public static Context newAsyncContext(DefaultNode entranceNode, String name) {
        return new Context(name, entranceNode, true);
    }

    public Context(DefaultNode entranceNode, String name) {
        this(name, entranceNode, false);
    }

    public Context(String name, DefaultNode entranceNode, boolean async) {
        this.name = name;
        this.entranceNode = entranceNode;
        this.async = async;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getName() {
        return this.name;
    }

    public Node getCurNode() {
        return this.curEntry.getCurNode();
    }

    public Context setCurNode(Node node) {
        this.curEntry.setCurNode(node);
        return this;
    }

    public Entry getCurEntry() {
        return this.curEntry;
    }

    public Context setCurEntry(Entry curEntry) {
        this.curEntry = curEntry;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Context setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public double getOriginTotalQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().totalQps();
    }

    public double getOriginBlockQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().blockQps();
    }

    public double getOriginPassReqQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().successQps();
    }

    public double getOriginPassQps() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().passQps();
    }

    public long getOriginTotalRequest() {
        return this.getOriginNode() == null ? 0L : this.getOriginNode().totalRequest();
    }

    public long getOriginBlockRequest() {
        return this.getOriginNode() == null ? 0L : this.getOriginNode().blockRequest();
    }

    public double getOriginAvgRt() {
        return this.getOriginNode() == null ? 0.0 : (double)this.getOriginNode().avgRt();
    }

    public int getOriginCurThreadNum() {
        return this.getOriginNode() == null ? 0 : this.getOriginNode().curThreadNum();
    }

    public DefaultNode getEntranceNode() {
        return this.entranceNode;
    }

    public Node getLastNode() {
        if (this.curEntry != null && this.curEntry.getLastNode() != null) {
            return this.curEntry.getLastNode();
        }
        return this.entranceNode;
    }

    public Node getOriginNode() {
        return this.curEntry == null ? null : this.curEntry.getOriginNode();
    }

    public String toString() {
        return "Context{name='" + this.name + '\'' + ", entranceNode=" + this.entranceNode + ", curEntry=" + this.curEntry + ", origin='" + this.origin + '\'' + ", async=" + this.async + '}';
    }
}

