/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slots.statistic.metric.ArrayMetric;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StatisticNode
implements Node {
    private volatile transient Metric rollingCounterInSecond = new ArrayMetric(1000 / SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
    private transient Metric rollingCounterInMinute = new ArrayMetric(1000, 60);
    private AtomicInteger curThreadNum = new AtomicInteger(0);
    private long lastFetchTime = -1L;

    @Override
    public Map<Long, MetricNode> metrics() {
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        ConcurrentHashMap<Long, MetricNode> metrics = new ConcurrentHashMap<Long, MetricNode>();
        List<MetricNode> nodesOfEverySecond = this.rollingCounterInMinute.details();
        long newLastFetchTime = this.lastFetchTime;
        for (MetricNode node : nodesOfEverySecond) {
            if (!this.isNodeInTime(node, currentTime) || !this.isValidMetricNode(node)) continue;
            metrics.put(node.getTimestamp(), node);
            newLastFetchTime = Math.max(newLastFetchTime, node.getTimestamp());
        }
        this.lastFetchTime = newLastFetchTime;
        return metrics;
    }

    private boolean isNodeInTime(MetricNode node, long currentTime) {
        return node.getTimestamp() > this.lastFetchTime && node.getTimestamp() < currentTime;
    }

    private boolean isValidMetricNode(MetricNode node) {
        return node.getPassQps() > 0L || node.getBlockQps() > 0L || node.getSuccessQps() > 0L || node.getExceptionQps() > 0L || node.getRt() > 0L;
    }

    @Override
    public void reset() {
        this.rollingCounterInSecond = new ArrayMetric(1000 / SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
    }

    @Override
    public long totalRequest() {
        long totalRequest = this.rollingCounterInMinute.pass() + this.rollingCounterInMinute.block();
        return totalRequest;
    }

    @Override
    public long blockRequest() {
        return this.rollingCounterInMinute.block();
    }

    @Override
    public long blockQps() {
        return this.rollingCounterInSecond.block() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long previousBlockQps() {
        return this.rollingCounterInMinute.previousWindowBlock();
    }

    @Override
    public long previousPassQps() {
        return this.rollingCounterInMinute.previousWindowPass();
    }

    @Override
    public long totalQps() {
        return this.passQps() + this.blockQps();
    }

    @Override
    public long totalSuccess() {
        return this.rollingCounterInMinute.success();
    }

    @Override
    public long exceptionQps() {
        return this.rollingCounterInSecond.exception() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long totalException() {
        return this.rollingCounterInMinute.exception();
    }

    @Override
    public long passQps() {
        return this.rollingCounterInSecond.pass() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long successQps() {
        return this.rollingCounterInSecond.success() / (long)IntervalProperty.INTERVAL;
    }

    @Override
    public long maxSuccessQps() {
        return this.rollingCounterInSecond.maxSuccess() * (long)SampleCountProperty.SAMPLE_COUNT;
    }

    @Override
    public long avgRt() {
        long successCount = this.rollingCounterInSecond.success();
        if (successCount == 0L) {
            return 0L;
        }
        return this.rollingCounterInSecond.rt() / successCount;
    }

    @Override
    public long minRt() {
        return this.rollingCounterInSecond.minRt();
    }

    @Override
    public int curThreadNum() {
        return this.curThreadNum.get();
    }

    @Override
    public void addPassRequest() {
        this.rollingCounterInSecond.addPass();
        this.rollingCounterInMinute.addPass();
    }

    @Override
    public void rt(long rt) {
        this.rollingCounterInSecond.addSuccess();
        this.rollingCounterInSecond.addRT(rt);
        this.rollingCounterInMinute.addSuccess();
        this.rollingCounterInMinute.addRT(rt);
    }

    @Override
    public void increaseBlockQps() {
        this.rollingCounterInSecond.addBlock();
        this.rollingCounterInMinute.addBlock();
    }

    @Override
    public void increaseExceptionQps() {
        this.rollingCounterInSecond.addException();
        this.rollingCounterInMinute.addException();
    }

    @Override
    public void increaseThreadNum() {
        this.curThreadNum.incrementAndGet();
    }

    @Override
    public void decreaseThreadNum() {
        this.curThreadNum.decrementAndGet();
    }

    @Override
    public void debug() {
        this.rollingCounterInSecond.debugQps();
    }
}

