/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MetricNode {
    private long timestamp;
    private long passQps;
    private long blockQps;
    private long successQps;
    private long exceptionQps;
    private long rt;
    private String resource;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getSuccessQps() {
        return this.successQps;
    }

    public void setSuccessQps(long successQps) {
        this.successQps = successQps;
    }

    public long getPassQps() {
        return this.passQps;
    }

    public void setPassQps(long passQps) {
        this.passQps = passQps;
    }

    public long getExceptionQps() {
        return this.exceptionQps;
    }

    public void setExceptionQps(long exceptionQps) {
        this.exceptionQps = exceptionQps;
    }

    public long getBlockQps() {
        return this.blockQps;
    }

    public void setBlockQps(long blockQps) {
        this.blockQps = blockQps;
    }

    public long getRt() {
        return this.rt;
    }

    public void setRt(long rt) {
        this.rt = rt;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String toString() {
        return "MetricNode{timestamp=" + this.timestamp + ", passQps=" + this.passQps + ", blockQps=" + this.blockQps + ", successQps=" + this.successQps + ", exceptionQps=" + this.exceptionQps + ", rt=" + this.rt + ", resource='" + this.resource + '\'' + '}';
    }

    public String toThinString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp).append("|");
        String legalName = this.resource.replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.passQps).append("|");
        sb.append(this.blockQps).append("|");
        sb.append(this.successQps).append("|");
        sb.append(this.exceptionQps).append("|");
        sb.append(this.rt);
        return sb.toString();
    }

    public static MetricNode fromThinString(String line) {
        MetricNode node = new MetricNode();
        String[] strs = line.split("\\|");
        node.setTimestamp(Long.parseLong(strs[0]));
        node.setResource(strs[1]);
        node.setPassQps(Long.parseLong(strs[2]));
        node.setBlockQps(Long.parseLong(strs[3]));
        node.setSuccessQps(Long.parseLong(strs[4]));
        node.setExceptionQps(Long.parseLong(strs[5]));
        node.setRt(Long.parseLong(strs[6]));
        return node;
    }

    public String toFatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder(32);
        sb.delete(0, sb.length());
        sb.append(this.getTimestamp()).append("|");
        sb.append(df.format(new Date(this.getTimestamp()))).append("|");
        String legalName = this.getResource().replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.getPassQps()).append("|");
        sb.append(this.getBlockQps()).append("|");
        sb.append(this.getSuccessQps()).append("|");
        sb.append(this.getExceptionQps()).append("|");
        sb.append(this.getRt());
        sb.append('\n');
        return sb.toString();
    }

    public static MetricNode fromFatString(String line) {
        String[] strs = line.split("\\|");
        Long time = Long.parseLong(strs[0]);
        MetricNode node = new MetricNode();
        node.setTimestamp(time);
        node.setResource(strs[2]);
        node.setPassQps(Long.parseLong(strs[3]));
        node.setBlockQps(Long.parseLong(strs[4]));
        node.setSuccessQps(Long.parseLong(strs[5]));
        node.setExceptionQps(Long.parseLong(strs[6]));
        node.setRt(Long.parseLong(strs[7]));
        return node;
    }
}

