/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiterController
implements TrafficShapingController {
    private final int maxQueueingTimeMs;
    private final double count;
    private final AtomicLong latestPassedTime = new AtomicLong(-1L);

    public RateLimiterController(int timeOut, double count) {
        this.maxQueueingTimeMs = timeOut;
        this.count = count;
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        long currentTime = TimeUtil.currentTimeMillis();
        long costTime = Math.round(1.0 * (double)acquireCount / this.count * 1000.0);
        long expectedTime = costTime + this.latestPassedTime.get();
        if (expectedTime <= currentTime) {
            this.latestPassedTime.set(currentTime);
            return true;
        }
        long waitTime = costTime + this.latestPassedTime.get() - TimeUtil.currentTimeMillis();
        if (waitTime >= (long)this.maxQueueingTimeMs) {
            return false;
        }
        long oldTime = this.latestPassedTime.addAndGet(costTime);
        try {
            waitTime = oldTime - TimeUtil.currentTimeMillis();
            if (waitTime >= (long)this.maxQueueingTimeMs) {
                this.latestPassedTime.addAndGet(-costTime);
                return false;
            }
            Thread.sleep(waitTime);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

