/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.RuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ParamFlowRuleManager {
    private static final RuleManager<ParamFlowRule> PARAM_FLOW_RULES = new RuleManager();
    private static final RulePropertyListener PROPERTY_LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<ParamFlowRule>> currentProperty = new DynamicSentinelProperty();

    public static void loadRules(List<ParamFlowRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.info((String)"[ParamFlowRuleManager] Failed to load rules", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<ParamFlowRule>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        RulePropertyListener rulePropertyListener = PROPERTY_LISTENER;
        synchronized (rulePropertyListener) {
            currentProperty.removeListener((PropertyListener)PROPERTY_LISTENER);
            property.addListener((PropertyListener)PROPERTY_LISTENER);
            currentProperty = property;
            RecordLog.info((String)"[ParamFlowRuleManager] New property has been registered to hot param rule manager", (Object[])new Object[0]);
        }
    }

    public static List<ParamFlowRule> getRulesOfResource(String resourceName) {
        return new ArrayList<ParamFlowRule>(PARAM_FLOW_RULES.getRules(resourceName));
    }

    public static boolean hasRules(String resourceName) {
        return PARAM_FLOW_RULES.hasConfig(resourceName);
    }

    public static List<ParamFlowRule> getRules() {
        return PARAM_FLOW_RULES.getRules();
    }

    private ParamFlowRuleManager() {
    }

    static {
        currentProperty.addListener((PropertyListener)PROPERTY_LISTENER);
    }

    static class RulePropertyListener
    implements PropertyListener<List<ParamFlowRule>> {
        RulePropertyListener() {
        }

        public void configUpdate(List<ParamFlowRule> list) {
            Map<String, List<ParamFlowRule>> rules = this.aggregateAndPrepareParamRules(list);
            PARAM_FLOW_RULES.updateRules(rules);
            RecordLog.info((String)"[ParamFlowRuleManager] Parameter flow rules received: {}", (Object[])new Object[]{PARAM_FLOW_RULES});
        }

        public void configLoad(List<ParamFlowRule> list) {
            Map<String, List<ParamFlowRule>> rules = this.aggregateAndPrepareParamRules(list);
            PARAM_FLOW_RULES.updateRules(rules);
            RecordLog.info((String)"[ParamFlowRuleManager] Parameter flow rules received: {}", (Object[])new Object[]{PARAM_FLOW_RULES});
        }

        private Map<String, List<ParamFlowRule>> aggregateAndPrepareParamRules(List<ParamFlowRule> list) {
            Map<String, List<ParamFlowRule>> newRuleMap = ParamFlowRuleUtil.buildParamRuleMap(list);
            if (newRuleMap == null || newRuleMap.isEmpty()) {
                ParameterMetricStorage.getMetricsMap().clear();
                RecordLog.info((String)"[ParamFlowRuleManager] No parameter flow rules, clearing all parameter metrics", (Object[])new Object[0]);
                return newRuleMap;
            }
            for (Map.Entry entry : PARAM_FLOW_RULES.getOriginalRules().entrySet()) {
                String resource = (String)entry.getKey();
                if (!newRuleMap.containsKey(resource)) {
                    ParameterMetricStorage.clearParamMetricForResource(resource);
                    continue;
                }
                List<ParamFlowRule> newRuleList = newRuleMap.get(resource);
                ArrayList oldRuleList = new ArrayList((Collection)entry.getValue());
                oldRuleList.removeAll(newRuleList);
                for (ParamFlowRule rule : oldRuleList) {
                    ParameterMetric parameterMetric = ParameterMetricStorage.getParamMetricForResource(resource);
                    if (parameterMetric == null) continue;
                    parameterMetric.clearForRule(rule);
                }
            }
            return newRuleMap;
        }
    }
}

