/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc.callback;

import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.BlockRequestHandler;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultBlockRequestHandler
implements BlockRequestHandler {
    private static final String DEFAULT_BLOCK_MSG_PREFIX = "Blocked by Sentinel: ";

    @Override
    public Mono<ServerResponse> handleRequest(ServerWebExchange exchange, Throwable ex) {
        if (this.acceptsHtml(exchange)) {
            return this.htmlErrorResponse(ex);
        }
        return ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)this.buildErrorResult(ex)));
    }

    private Mono<ServerResponse> htmlErrorResponse(Throwable ex) {
        return ServerResponse.status((HttpStatus)HttpStatus.TOO_MANY_REQUESTS).contentType(MediaType.TEXT_PLAIN).syncBody((Object)(DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName()));
    }

    private ErrorResult buildErrorResult(Throwable ex) {
        return new ErrorResult(HttpStatus.TOO_MANY_REQUESTS.value(), DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName());
    }

    private boolean acceptsHtml(ServerWebExchange exchange) {
        try {
            List acceptedMediaTypes = exchange.getRequest().getHeaders().getAccept();
            acceptedMediaTypes.remove(MediaType.ALL);
            MediaType.sortBySpecificityAndQuality((List)acceptedMediaTypes);
            return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    private static class ErrorResult {
        private final int code;
        private final String message;

        ErrorResult(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

