/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandHandlerInterceptor;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.command.handler.InterceptingCommandHandler;
import com.alibaba.csp.sentinel.spi.SpiLoader;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandHandlerProvider
implements Iterable<CommandHandler> {
    private final SpiLoader<CommandHandler> spiLoader = SpiLoader.of(CommandHandler.class);
    private static final CommandHandlerProvider INSTANCE = new CommandHandlerProvider();

    public Map<String, CommandHandler> namedHandlers() {
        HashMap<String, CommandHandler> map = new HashMap<String, CommandHandler>();
        List handlers = this.spiLoader.loadInstanceList();
        List commandHandlerInterceptors = SpiLoader.of(CommandHandlerInterceptor.class).loadInstanceListSorted();
        for (InterceptingCommandHandler handler : handlers) {
            String name = this.parseCommandName(handler);
            if (StringUtil.isEmpty((String)name)) continue;
            if (!commandHandlerInterceptors.isEmpty()) {
                ArrayList interceptors = new ArrayList();
                for (CommandHandlerInterceptor commandHandlerInterceptor : commandHandlerInterceptors) {
                    if (!commandHandlerInterceptor.shouldIntercept(name)) continue;
                    interceptors.add(commandHandlerInterceptor);
                }
                if (!interceptors.isEmpty()) {
                    handler = new InterceptingCommandHandler(handler, interceptors);
                }
            }
            map.put(name, handler);
        }
        return map;
    }

    private String parseCommandName(CommandHandler handler) {
        CommandMapping commandMapping = handler.getClass().getAnnotation(CommandMapping.class);
        if (commandMapping != null) {
            return commandMapping.name();
        }
        return null;
    }

    @Override
    public Iterator<CommandHandler> iterator() {
        return this.spiLoader.loadInstanceList().iterator();
    }

    public static CommandHandlerProvider getInstance() {
        return INSTANCE;
    }
}

