/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.shade.io.netty.handler.codec.sctp;

import com.alibaba.rocketmq.shade.io.netty.buffer.ByteBuf;
import com.alibaba.rocketmq.shade.io.netty.buffer.Unpooled;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.rocketmq.shade.io.netty.channel.sctp.SctpMessage;
import com.alibaba.rocketmq.shade.io.netty.handler.codec.MessageToMessageDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SctpMessageCompletionHandler
extends MessageToMessageDecoder<SctpMessage> {
    private final Map<Integer, ByteBuf> fragments = new HashMap<Integer, ByteBuf>();

    @Override
    protected void decode(ChannelHandlerContext ctx, SctpMessage msg, List<Object> out) throws Exception {
        ByteBuf byteBuf = msg.content();
        int protocolIdentifier = msg.protocolIdentifier();
        int streamIdentifier = msg.streamIdentifier();
        boolean isComplete = msg.isComplete();
        boolean isUnordered = msg.isUnordered();
        ByteBuf frag = this.fragments.containsKey(streamIdentifier) ? this.fragments.remove(streamIdentifier) : Unpooled.EMPTY_BUFFER;
        if (isComplete && !frag.isReadable()) {
            out.add(msg);
        } else if (!isComplete && frag.isReadable()) {
            this.fragments.put(streamIdentifier, Unpooled.wrappedBuffer(frag, byteBuf));
        } else if (isComplete && frag.isReadable()) {
            this.fragments.remove(streamIdentifier);
            SctpMessage assembledMsg = new SctpMessage(protocolIdentifier, streamIdentifier, isUnordered, Unpooled.wrappedBuffer(frag, byteBuf));
            out.add(assembledMsg);
        } else {
            this.fragments.put(streamIdentifier, byteBuf);
        }
        byteBuf.retain();
    }
}

