/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop;

import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import com.aliyun.sdk.gateway.pop.auth.signer.PopV1Signer;
import com.aliyun.sdk.gateway.pop.auth.signer.PopV3Signer;
import com.aliyun.sdk.gateway.pop.auth.signer.PopV4Signer;
import com.aliyun.sdk.gateway.pop.interceptor.configuration.EndpointInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.HttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.RoaHttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.RpcHttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.output.FinalizedOutputInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.ReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.RoaReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.RpcReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.response.PopResInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.response.TeaResponseInterceptor;
import com.aliyun.sdk.gateway.pop.policy.POPUserAgentPolicy;
import darabonba.core.TeaClientBuilder;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.IClientBuilder;
import darabonba.core.interceptor.ConfigurationInterceptor;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorChain;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

public abstract class BaseClientBuilder<BuilderT extends IClientBuilder<BuilderT, ClientT>, ClientT>
extends TeaClientBuilder<BuilderT, ClientT> {
    protected String serviceName() {
        return "POP";
    }

    public BuilderT serviceConfiguration(Configuration serviceConfiguration) {
        this.clientConfiguration.setOption(ClientOption.SERVICE_CONFIGURATION, (Object)serviceConfiguration);
        return (BuilderT)((Object)this);
    }

    protected ClientConfiguration mergeServiceDefaults(ClientConfiguration configuration) {
        return configuration.merge(ClientConfiguration.create().setOption(ClientOption.SERVICE_CONFIGURATION, (Object)Configuration.create()).setOption(ClientOption.USER_AGENT_SERVICE_SUFFIX, (Object)POPUserAgentPolicy.getDefaultUserAgentSuffix()));
    }

    protected ClientConfiguration finalizeServiceConfiguration(ClientConfiguration configuration) {
        PopSigner signer;
        InterceptorChain chain = InterceptorChain.create();
        chain.addConfigurationInterceptor((ConfigurationInterceptor)new EndpointInterceptor());
        chain.addRequestInterceptor((RequestInterceptor)new RpcReqInterceptor());
        chain.addRequestInterceptor((RequestInterceptor)new RoaReqInterceptor());
        chain.addRequestInterceptor((RequestInterceptor)new ReqInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new RpcHttpReqInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new RoaHttpReqInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new HttpReqInterceptor());
        chain.addResponseInterceptor((ResponseInterceptor)new TeaResponseInterceptor());
        chain.addResponseInterceptor((ResponseInterceptor)new PopResInterceptor());
        chain.addOutputInterceptor((OutputInterceptor)new FinalizedOutputInterceptor());
        configuration.setOption(ClientOption.INTERCEPTOR_CHAIN, (Object)chain);
        Configuration config = (Configuration)configuration.option(ClientOption.SERVICE_CONFIGURATION);
        if (CommonUtil.isUnset((Object)config)) {
            signer = new PopV1Signer(Configuration.DEFAULT_SIGNATURE_ALGORRITHM_V1);
            config = Configuration.create();
            configuration.setOption(ClientOption.SERVICE_CONFIGURATION, (Object)config);
        } else {
            signer = config.signatureVersion() == SignatureVersion.V3 ? new PopV3Signer(config.signatureAlgorithmV3()) : (config.signatureVersion() == SignatureVersion.V4 ? new PopV4Signer(config.signatureAlgorithmV4()) : new PopV1Signer(config.signatureAlgorithmV1()));
        }
        configuration.setOption(ClientOption.SIGNER, (Object)signer);
        return configuration;
    }
}

