/*
 * Decompiled with CFR 0.152.
 */
package alibaba.drcnet.impl;

import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.connection.SingleDecomressConnection;
import alibaba.drcnet.enums.ConnType;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.MessageIDUtil;
import alibaba.drcnet.util.MessageV1;
import alibaba.drcnet.util.SyncState;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRCNETClientImpl {
    private static final Logger log = LoggerFactory.getLogger(DRCNETClientImpl.class);
    private Connection connection = null;
    private SyncState syncState = null;
    private UserConfig userConfig = null;
    private MessageIDUtil messageIDUtil = null;
    private boolean useId = false;
    private String ip;
    private String port;
    private boolean stopped = false;

    private int initSyncState(ConnType connType) {
        this.syncState = new SyncState(false);
        if (null == this.syncState) {
            log.error("get meme failed");
            return -1;
        }
        int ret = 0;
        this.syncState.setConnType(connType);
        switch (connType) {
            case SINGLE_NOID_ENCRYPT_CONN: {
                this.syncState.setIDidenRequired(false);
                this.syncState.setForceEncrypt(true);
                this.syncState.setUseOldConnecionSyncWay(false);
                break;
            }
            case SINGLE_NOID_NOENCRYPT_CONN: {
                this.syncState.setIDidenRequired(false);
                this.syncState.setForceEncrypt(false);
                this.syncState.setUseOldConnecionSyncWay(false);
                break;
            }
            case SINGLE_WITHID_ENCRYPT_CONN: {
                this.syncState.setIDidenRequired(true);
                this.syncState.setForceEncrypt(true);
                this.syncState.setUseOldConnecionSyncWay(false);
                this.useId = true;
                break;
            }
            case SINGLE_WITHID_NOENCRYPT_CONN: {
                this.syncState.setIDidenRequired(true);
                this.syncState.setForceEncrypt(false);
                this.syncState.setUseOldConnecionSyncWay(false);
                this.useId = true;
                break;
            }
            case OLD_WAY_CONN: {
                this.syncState.setUseOldConnecionSyncWay(true);
                break;
            }
            default: {
                log.error("unkown msg type");
                ret = -1;
            }
        }
        return ret;
    }

    private int initDrcNet(ConnType connType) {
        if (connType != ConnType.UNKONWN_TYPE) {
            if (0 != this.initSyncState(connType)) {
                log.error("init sync state failed");
                return -1;
            }
            this.connection = new SingleDecomressConnection();
            if (this.syncState == null || this.connection == null) {
                log.error("get meme failed");
                return -1;
            }
            return 0;
        }
        log.error("multi conn not support yet");
        return -1;
    }

    private int preCheck(ConnType connType, DRCNetConfig drcnetConfig) {
        if (!(ConnType.SINGLE_WITHID_ENCRYPT_CONN != connType && ConnType.SINGLE_NOID_ENCRYPT_CONN != connType || null != drcnetConfig.getClientAuthString() && null != drcnetConfig.serverTokenAuthTool)) {
            log.error("drcnet error: encrypt mode required, but auth string and auth interface not set");
            return -1;
        }
        return 0;
    }

    public int startDRCNet(String ip, String port, ConnType connType, DRCNetConfig drcnetConfig, Map<String, String> userConfigMap, int connectionTimeOut) {
        try {
            if (0 > this.preCheck(connType, drcnetConfig)) {
                return -1;
            }
            if (this.initDrcNet(connType) < 0) {
                log.error("init drcnet failed");
                return -1;
            }
            this.stopped = false;
            this.userConfig = new UserConfig();
            for (Map.Entry<String, String> entry : userConfigMap.entrySet()) {
                this.userConfig.putConfig(entry.getKey(), entry.getValue());
            }
            if (this.connection.startConnection(ip, port, this.userConfig, drcnetConfig, this.syncState, connectionTimeOut) < 0) {
                log.error("start conn failed");
                this.stopped = true;
                return -1;
            }
            if (this.useId && 0L >= this.syncState.getMaxMessageID()) {
                log.error("start with id failed");
                this.stopped = true;
                return -1;
            }
            this.messageIDUtil = new MessageIDUtil(this.syncState.getMaxMessageID());
            return 0;
        }
        catch (Exception e) {
            log.error("start drcnet failed");
            this.stopped = true;
            return -1;
        }
    }

    public void stopDRCNet() {
        this.connection.stopConnection();
        this.stopped = true;
    }

    public int readMsg(DRCNetMessageInfo msgInfo) {
        long nextMessageId;
        int readRet = this.connection.readData(msgInfo, this.useId);
        if (this.useId && msgInfo.messageID != (nextMessageId = this.messageIDUtil.getNextMessageID())) {
            log.error(" message id don't math  from begin");
            return -1;
        }
        if (msgInfo.isBigMsg) {
            if (readRet < 0) {
                log.error("read msg error");
                return -1;
            }
            if (!MessageV1.isBigMsgBegin(msgInfo.type)) {
                log.error("big msg begin not match");
                return -1;
            }
            int arrIndex = 0;
            DRCNetMessageInfo retMsgInfo = new DRCNetMessageInfo();
            retMsgInfo.orgLen = msgInfo.orgLen;
            retMsgInfo.isBigMsg = true;
            retMsgInfo.buf = new byte[(int)msgInfo.orgLen];
            retMsgInfo.bufLen = msgInfo.orgLen;
            do {
                long nextMessageId2;
                System.arraycopy(msgInfo.buf, 0, retMsgInfo.buf, arrIndex, (int)msgInfo.bufLen);
                arrIndex = (int)((long)arrIndex + msgInfo.bufLen);
                readRet = this.connection.readData(msgInfo, this.useId);
                if (readRet < 0) {
                    log.error("read big msg more error");
                    return -1;
                }
                if (!this.useId || msgInfo.messageID == (nextMessageId2 = this.messageIDUtil.getNextMessageID())) continue;
                log.error(" message id don't math  from begin");
                return -1;
            } while (MessageV1.isBigMsgMore(msgInfo.type));
            if (!MessageV1.isBigMsgEnd(msgInfo.type)) {
                log.error("read big msg end failed");
                return -1;
            }
            System.arraycopy(msgInfo.buf, 0, retMsgInfo.buf, arrIndex, (int)msgInfo.bufLen);
            arrIndex = (int)((long)arrIndex + msgInfo.bufLen);
            if ((long)arrIndex != retMsgInfo.orgLen) {
                log.error("big msg length check failed");
                return -1;
            }
            msgInfo.buf = retMsgInfo.buf;
            msgInfo.bufLen = retMsgInfo.bufLen;
            return readRet;
        }
        return readRet;
    }

    public int readSingleMsg(DRCNetMessageInfo mesInfo) {
        return this.connection.readData(mesInfo, this.useId);
    }
}

