/*
 * Decompiled with CFR 0.152.
 */
package alibaba.drcnet.processer;

import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.buffer.TempBuf;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.decoder.Decoder;
import alibaba.drcnet.decoder.lz4Decoder;
import alibaba.drcnet.enums.DRCNetCompressState;
import alibaba.drcnet.enums.DataProcessState;
import alibaba.drcnet.processer.NetDataProcesser;
import alibaba.drcnet.util.AesCrypto;
import alibaba.drcnet.util.Constant;
import alibaba.drcnet.util.MessageV1;
import alibaba.drcnet.util.RandomByte;
import alibaba.drcnet.util.RsaCrypto;
import alibaba.drcnet.util.ServerTokenAuthTool;
import alibaba.drcnet.util.SyncState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRCNetProcesser
implements NetDataProcesser {
    private static final Logger log = LoggerFactory.getLogger(DRCNetProcesser.class);
    private static final int MAGIC_NUMBER_SIZE = 25;
    private static final String MAGIC_NUMBER_STR = "kjnkjabhbanc283ubcsbhdc72";
    private static final String SYNC_DONE_STRING = "done";
    private static final byte ASK_ID = 1;
    private static final byte START_CONNECTION = 2;
    private static final byte SINGLE_CONNECTION = 4;
    private static final byte MULTI_CONNECTION = 5;
    private static final byte SYNC_BEGIN_MSG = 9;
    private static final byte SYNC_CONTINUE_MSG = 10;
    private static final byte SYNC_END_MSG = 11;
    private static final byte SYNC_ENCRYPT_MSG = 0;
    private static final byte ACCEPT_CONNECTION = 97;
    private DRCNetCompressState state = DRCNetCompressState.MAGIC_NUMBER;
    private DataProcessState dataProcessState = DataProcessState.READ_HEAD;
    private Decoder decoder = null;
    private long id;
    private long serverVersion = 0L;
    public static final long maxCtlMsgLen = 5000L;
    private static final short compressFlag = 129;
    private static final short uncompressFlag = 130;
    private static final short compressAndEncryptFlag = 131;
    private static final short uncompressAndEncryptFlag = 132;
    private short compressIndicate = 0;
    private long compressSize = 0L;
    private long orglenLen = 0L;
    private TempBuf tempAuthStringBuf = null;
    private TempBuf tempIntBuf = null;
    private TempBuf encryptBuf = null;
    private byte[] compressHeader = null;
    private int compressHeaderIndex = 0;
    private int contentBufferSize = 0;
    private byte[] contetnBuffer = null;
    private int contentBufferOffset = 0;
    private long contentLen = 0L;
    private long recvServerBufSize = 0L;
    private long leftData = 5L;
    private AesCrypto aesCrypto = null;
    private RsaCrypto rsaCrypto = null;
    private long rsaPublicKeyLength = 0L;
    private long serverTokenLength = 0L;
    private long serverEncryptLen = 0L;
    private long serverOkLen = 0L;
    private int randomIndex1 = -1;
    private int randomIndex2 = -1;

    @Override
    public boolean process(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, CacheBuff buf, SyncState syncState, Connection conn) throws Exception {
        while (byteBuf.isReadable()) {
            switch (this.state) {
                case MAGIC_NUMBER: {
                    this.processHandShake(byteBuf);
                    break;
                }
                case SERVER_VERSION: {
                    this.processServerVersion(ctx, byteBuf, userConfig, syncState);
                    break;
                }
                case GET_IDENTIFY: {
                    this.processGetId(ctx, byteBuf, userConfig, drcnetConfig, buf, syncState, conn);
                    break;
                }
                case GET_SUBVERSION_MSG_ENCRYPT_INFO: {
                    this.processServerSubVersionMsg(ctx, byteBuf, userConfig, drcnetConfig, syncState, conn);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_TOKEN_LEN: {
                    this.processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_TOKEN_LEN);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_TOKEN: {
                    this.processServerToken(byteBuf, drcnetConfig);
                    break;
                }
                case ENCRYPT_AUTH_RSA_PUBLIC_KEY_LEN: {
                    this.processEncryptRecvLen(byteBuf, RecvBufState.RECVING_RSA_PUBLIC_KEY_LEN);
                    break;
                }
                case ENCRYPT_AUTH_RSA_PUBLIC_KEY: {
                    this.processRsaKey(ctx, byteBuf, drcnetConfig);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_AES_ENCRYPT_LEN: {
                    this.processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_ENCRYPT_STRING_LEN);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_AES_ENCRYPT_CONTENT: {
                    this.processAesEncryptInfo(ctx, byteBuf);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_OK_LEN: {
                    this.processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_OK_STRING_LEN);
                    break;
                }
                case ENCRYPT_AUTH_SERVER_OK_CONTENT: {
                    this.processSyncDoneInfo(ctx, byteBuf, userConfig, syncState, conn);
                    break;
                }
                case GET_HANDSHAKE: {
                    this.processOKMsg(byteBuf);
                    break;
                }
                case READ_COMPRESS_HEADER: {
                    int readableSize = byteBuf.readableBytes();
                    if ((long)readableSize >= this.leftData) {
                        byteBuf.readBytes(this.compressHeader, this.compressHeaderIndex, (int)this.leftData);
                        this.compressIndicate = (short)(this.compressHeader[0] & 0xFF);
                        this.contentLen = this.leftData = MessageV1.getInt32(this.compressHeader, 1);
                        this.compressHeaderIndex = 0;
                        this.state = DRCNetCompressState.READ_NET_RAW_DATA;
                        break;
                    }
                    byteBuf.readBytes(this.compressHeader, this.compressHeaderIndex, readableSize);
                    this.compressHeaderIndex += readableSize;
                    this.leftData -= (long)readableSize;
                    break;
                }
                case READ_NET_RAW_DATA: {
                    int readableDataSize = byteBuf.readableBytes();
                    if ((long)readableDataSize >= this.leftData) {
                        byteBuf.readBytes(this.contetnBuffer, this.contentBufferOffset, (int)this.leftData);
                        if (this.compressIndicate == 129 || this.compressIndicate == 131) {
                            this.orglenLen = MessageV1.getInt32(this.contetnBuffer, 0);
                            this.compressSize = this.contentLen - 4L;
                        } else if (this.compressIndicate == 130 || this.compressIndicate == 132) {
                            this.orglenLen = this.compressSize = this.contentLen;
                        } else {
                            throw new Exception("read compress flag error");
                        }
                        this.porcessCompressContent(buf);
                        this.contentBufferOffset = 0;
                        this.leftData = 5L;
                        this.state = DRCNetCompressState.READ_COMPRESS_HEADER;
                        break;
                    }
                    byteBuf.readBytes(this.contetnBuffer, this.contentBufferOffset, readableDataSize);
                    this.contentBufferOffset += readableDataSize;
                    this.leftData -= (long)readableDataSize;
                    break;
                }
            }
        }
        return true;
    }

    public void processSyncDoneInfo(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, SyncState syncState, Connection conn) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.encryptBuf.leftDataLen) {
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, this.encryptBuf.leftDataLen);
            if (!SYNC_DONE_STRING.equals(new String(this.encryptBuf.recvDataBuffer))) {
                throw new Exception("drcnet error: sync done compare failed");
            }
            ByteBuf temp = Unpooled.buffer();
            conn.setSyncOK();
            this.sendUserParam(temp, ctx, userConfig, syncState, true, true);
            this.state = DRCNetCompressState.GET_HANDSHAKE;
        } else {
            log.warn("drcnet, sync recv half server content lenth, recv size " + readableSize);
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, readableSize);
            this.encryptBuf.moveIndex(readableSize);
        }
    }

    private void processAesEncryptInfo(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.encryptBuf.leftDataLen) {
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, this.encryptBuf.leftDataLen);
            if (0 > this.aesCrypto.decrypt(this.encryptBuf.recvDataBuffer, 0, this.encryptBuf.bufLen)) {
                throw new Exception("drcnet error: aes drscrypt failed");
            }
            byte[] authBytes1 = Constant.exchangeString[this.randomIndex1].getBytes();
            byte[] authBytes2 = Constant.exchangeString[this.randomIndex2].getBytes();
            byte[] compareBytes = new byte[authBytes1.length + authBytes2.length];
            System.arraycopy(authBytes1, 0, compareBytes, 0, authBytes1.length);
            System.arraycopy(authBytes2, 0, compareBytes, authBytes1.length, authBytes2.length);
            if (!RandomByte.byteArrayCompare(compareBytes, this.encryptBuf.recvDataBuffer)) {
                throw new Exception("drcnet error: server encrypt byte comapre failed");
            }
            if (0 > this.aesCrypto.encrypt(compareBytes, 0, compareBytes.length)) {
                throw new Exception("drcnet error: encrypt sync string failed");
            }
            ByteBuf temp = Unpooled.buffer();
            byte[] sendBuf = new byte[4];
            MessageV1.putInt32(sendBuf, 0, compareBytes.length);
            temp.writeBytes(sendBuf);
            temp.writeBytes(compareBytes);
            ctx.channel().writeAndFlush((Object)temp);
            this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_OK_LEN;
        } else {
            log.warn("drcnet, sync recv half server content lenth, recv size " + readableSize);
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, readableSize);
            this.encryptBuf.moveIndex(readableSize);
        }
    }

    private void processRsaKey(ChannelHandlerContext ctx, ByteBuf byteBuf, DRCNetConfig drcnetConfig) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.encryptBuf.leftDataLen) {
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, this.encryptBuf.leftDataLen);
            if (this.rsaCrypto.initEncryptCompt(this.encryptBuf.recvDataBuffer, null) < 0) {
                log.error("drcnet: init rsa failed");
                throw new Exception("drcnet error: init rsa failed");
            }
            byte[] aesPrivateKey = RandomByte.getRandomBytes(16);
            byte[] aesIV = RandomByte.getRandomBytes(16);
            this.randomIndex1 = RandomByte.nextInt(Constant.exchangeStringSize);
            this.randomIndex2 = RandomByte.nextInt(Constant.exchangeStringSize);
            byte[] toEncryptBuf = new byte[52 + drcnetConfig.getExtendStringLen()];
            MessageV1.putInt32(toEncryptBuf, 0, 16);
            System.arraycopy(aesPrivateKey, 0, toEncryptBuf, 4, 16);
            MessageV1.putInt32(toEncryptBuf, 20, 16);
            System.arraycopy(aesIV, 0, toEncryptBuf, 24, 16);
            MessageV1.putInt32(toEncryptBuf, 40, this.randomIndex1);
            MessageV1.putInt32(toEncryptBuf, 44, this.randomIndex2);
            MessageV1.putInt32(toEncryptBuf, 48, drcnetConfig.extendStringLen);
            if (null != drcnetConfig.getExtendString()) {
                System.arraycopy(drcnetConfig.getExtendString(), 0, toEncryptBuf, 52, drcnetConfig.getExtendStringLen());
            }
            byte[] toSendEncryptedbuff = this.rsaCrypto.encrypt(toEncryptBuf);
            ByteBuf temp = Unpooled.buffer();
            byte[] sendBuf = new byte[6];
            sendBuf[0] = 10;
            sendBuf[1] = 0;
            MessageV1.putInt32(sendBuf, 2, toSendEncryptedbuff.length);
            temp.writeBytes(sendBuf);
            temp.writeBytes(toSendEncryptedbuff);
            ctx.channel().writeAndFlush((Object)temp);
            RandomByte.shuffleByte(aesPrivateKey, 16);
            RandomByte.shuffleByte(aesIV, 16);
            if (0 > this.aesCrypto.initEncryptCompt(aesPrivateKey, aesIV)) {
                throw new Exception("drcnet error: ase crypto failed");
            }
            this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_AES_ENCRYPT_LEN;
        } else {
            log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, readableSize);
            this.encryptBuf.moveIndex(readableSize);
        }
    }

    private void processServerToken(ByteBuf byteBuf, DRCNetConfig drcnetConfig) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.encryptBuf.leftDataLen) {
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, this.encryptBuf.leftDataLen);
            ServerTokenAuthTool serverAuthFunc = drcnetConfig.getServerTokenAuthTool();
            if (!serverAuthFunc.authServerToken(this.encryptBuf.recvDataBuffer, this.encryptBuf.bufLen)) {
                throw new Exception("auth server failed, token is " + new String(this.encryptBuf.recvDataBuffer));
            }
            this.state = DRCNetCompressState.ENCRYPT_AUTH_RSA_PUBLIC_KEY_LEN;
        } else {
            log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, readableSize);
            this.encryptBuf.moveIndex(readableSize);
        }
    }

    private void processEncryptRecvLen(ByteBuf byteBuf, RecvBufState recv_state) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.tempIntBuf.leftDataLen) {
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, this.tempIntBuf.leftDataLen);
            switch (recv_state) {
                case RECVING_SERVER_TOKEN_LEN: {
                    this.serverTokenLength = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
                    this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_TOKEN;
                    break;
                }
                case RECVING_RSA_PUBLIC_KEY_LEN: {
                    this.rsaPublicKeyLength = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
                    this.state = DRCNetCompressState.ENCRYPT_AUTH_RSA_PUBLIC_KEY;
                    break;
                }
                case RECVING_SERVER_ENCRYPT_STRING_LEN: {
                    this.serverEncryptLen = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
                    this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_AES_ENCRYPT_CONTENT;
                    break;
                }
                case RECVING_SERVER_OK_STRING_LEN: {
                    this.serverOkLen = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
                    this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_OK_CONTENT;
                    break;
                }
                default: {
                    throw new Exception("drcnet error: unknow len type");
                }
            }
            long toRecvBufLen = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
            this.checkPackLen(toRecvBufLen);
            this.encryptBuf.initTempBuf((int)toRecvBufLen);
            this.tempIntBuf.initTempBuf(4);
        } else {
            log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, readableSize);
            this.tempIntBuf.moveIndex(readableSize);
        }
    }

    private void processServerSubVersionMsg(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, SyncState syncState, Connection conn) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.encryptBuf.leftDataLen) {
            boolean forceEncrypt;
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, this.encryptBuf.leftDataLen);
            long serverSubVersion = MessageV1.getInt32(this.encryptBuf.recvDataBuffer, 0);
            long serverMaxMessageID = MessageV1.getInt32(this.encryptBuf.recvDataBuffer, 4);
            long serverCircleSize = MessageV1.getInt32(this.encryptBuf.recvDataBuffer, 8);
            boolean bl = forceEncrypt = this.encryptBuf.recvDataBuffer[12] != 0;
            if (forceEncrypt) {
                syncState.setForceEncrypt(true);
            }
            if (1L > serverSubVersion) {
                log.error("sub version , client:1 should smaller than server: " + serverSubVersion);
                throw new Exception("drcnet error: sub version check failed");
            }
            if (0L >= serverMaxMessageID) {
                log.error("invalid message id: " + serverMaxMessageID);
                throw new Exception("drcnet error: invliad message id " + serverMaxMessageID);
            }
            syncState.setMaxMessageID(serverMaxMessageID);
            log.info("New Sync: using id " + syncState.isIDidenRequired() + ", using encrypt " + syncState.isForceEncrypt() + ", max message id from server " + syncState.getMaxMessageID());
            ByteBuf temp = Unpooled.buffer();
            if (!syncState.isForceEncrypt()) {
                conn.setSyncOK();
                this.sendUserParam(temp, ctx, userConfig, syncState, true, false);
                this.state = DRCNetCompressState.GET_HANDSHAKE;
            } else {
                if (null == drcnetConfig.getClientAuthString() || null == drcnetConfig.getServerTokenAuthTool() || 0 >= drcnetConfig.getClientAuthStringLen()) {
                    throw new Exception("client auth string is null or server auth tool is null");
                }
                byte[] sendBuf = new byte[6];
                sendBuf[0] = 10;
                sendBuf[1] = 0;
                MessageV1.putInt32(sendBuf, 2, drcnetConfig.getClientAuthStringLen());
                temp.writeBytes(sendBuf);
                temp.writeBytes(drcnetConfig.getClientAuthString());
                ctx.channel().writeAndFlush((Object)temp);
                this.tempIntBuf.initTempBuf(4);
                this.state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_TOKEN_LEN;
            }
        } else {
            log.warn("drcnet, sync recv half server subversion, recv size " + readableSize);
            byteBuf.readBytes(this.encryptBuf.recvDataBuffer, this.encryptBuf.currentWriteIndex, readableSize);
            this.encryptBuf.moveIndex(readableSize);
        }
    }

    private void processOKMsg(ByteBuf byteBuf) throws Exception {
        if (byteBuf.readByte() != 97) {
            throw new Exception("drcnet: recv hand shake failed");
        }
        log.info("accept");
        this.state = DRCNetCompressState.READ_COMPRESS_HEADER;
    }

    private void processGetId(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, CacheBuff buf, SyncState syncState, Connection conn) throws Exception {
        if (syncState.hasId || syncState.id != -1L) {
            syncState.releaseLock();
            log.error("get id dumpliacted");
            throw new Exception("get id dumpliacted");
        }
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.tempIntBuf.leftDataLen) {
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, this.tempIntBuf.leftDataLen);
            this.id = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
            if (this.serverVersion == 2L) {
                this.recvServerBufSize = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 4);
            } else if (this.serverVersion == 1L) {
                this.recvServerBufSize = 0x2000000L;
            }
            log.info("alloc id=" + this.id + ", server buf size: " + this.recvServerBufSize);
            syncState.id = this.id;
            syncState.hasId = true;
            syncState.releaseLock();
            drcnetConfig.setBufSize((int)this.recvServerBufSize);
            LZ4Factory factory = LZ4Factory.fastestInstance();
            LZ4Compressor compressor = factory.fastCompressor();
            this.contentBufferSize = (compressor.maxCompressedLength(drcnetConfig.getBufSize()) + 1023 + 9) / 1024 * 1024;
            this.contetnBuffer = new byte[this.contentBufferSize];
            log.warn("recv buf size is:" + this.contentBufferSize);
            if (buf == null) {
                throw new Exception("drcnet error: parent buffer can't be null");
            }
            buf.initBuf(drcnetConfig.getBufSize());
            if (conn == null) {
                throw new Exception("drcnet error: parent connection is null");
            }
            if (syncState.isUseOldConnecionSyncWay()) {
                conn.setSyncOK();
                ByteBuf temp = Unpooled.buffer();
                this.sendUserParam(temp, ctx, userConfig, syncState, false, false);
                this.state = DRCNetCompressState.GET_HANDSHAKE;
            } else {
                byte[] sendBuf = new byte[5];
                sendBuf[0] = 9;
                MessageV1.putInt32(sendBuf, 1, 1);
                ByteBuf temp = Unpooled.buffer();
                temp.writeBytes(sendBuf);
                ctx.channel().writeAndFlush((Object)temp);
                this.state = DRCNetCompressState.GET_SUBVERSION_MSG_ENCRYPT_INFO;
            }
        } else {
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, readableSize);
            this.tempIntBuf.moveIndex(readableSize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processServerVersion(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, SyncState syncState) throws Exception {
        int readableSize = byteBuf.readableBytes();
        if (readableSize >= this.tempIntBuf.leftDataLen) {
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, this.tempIntBuf.leftDataLen);
            this.serverVersion = MessageV1.getInt32(this.tempIntBuf.recvDataBuffer, 0);
            log.info("get server version " + this.serverVersion);
            syncState.getLock();
            ByteBuf temp = Unpooled.buffer();
            if (!syncState.hasId) {
                temp.writeByte(1);
                ctx.channel().writeAndFlush((Object)temp);
                this.state = DRCNetCompressState.GET_IDENTIFY;
            } else {
                this.sendUserParam(temp, ctx, userConfig, syncState, false, false);
                this.state = DRCNetCompressState.GET_HANDSHAKE;
                syncState.releaseLock();
            }
            if (this.serverVersion == 2L) {
                this.tempIntBuf.initTempBuf(8);
                return;
            } else {
                if (this.serverVersion != 1L) throw new Exception("drcnet server version not match: " + this.serverVersion);
                this.tempIntBuf.reiniSingleRecvBuf();
            }
            return;
        } else {
            log.warn("drcnet, sync recv half server version, recv size " + readableSize);
            byteBuf.readBytes(this.tempIntBuf.recvDataBuffer, this.tempIntBuf.currentWriteIndex, readableSize);
            this.tempIntBuf.moveIndex(readableSize);
        }
    }

    private void processHandShake(ByteBuf byteBuf) throws Exception {
        int readAbleSize = byteBuf.readableBytes();
        if (readAbleSize >= this.tempAuthStringBuf.leftDataLen) {
            byteBuf.readBytes(this.tempAuthStringBuf.recvDataBuffer, this.tempAuthStringBuf.currentWriteIndex, this.tempAuthStringBuf.leftDataLen);
            String magicNumber = new String(this.tempAuthStringBuf.recvDataBuffer);
            if (!magicNumber.equals(MAGIC_NUMBER_STR)) {
                throw new Exception("magic number compare failed, drcnet sync failed:" + magicNumber);
            }
            this.state = DRCNetCompressState.SERVER_VERSION;
        } else {
            log.warn("drc net sync recv half magic number, recv size " + readAbleSize);
            byteBuf.readBytes(this.tempAuthStringBuf.recvDataBuffer, this.tempAuthStringBuf.currentWriteIndex, readAbleSize);
            this.tempAuthStringBuf.moveIndex(readAbleSize);
        }
    }

    private void porcessCompressContent(CacheBuff buf) throws Exception {
        int writeIndex = buf.detectWriteable((int)this.orglenLen);
        if (writeIndex < 0) {
            throw new Exception("put buf failed, client may have stopped");
        }
        int moveIndex = 0;
        switch (this.compressIndicate) {
            case 129: {
                moveIndex = this.decoder.decoderWithCompress(this.contetnBuffer, 4, buf.writeBuf.buff, buf.writeBuf.writePos, (int)this.compressSize, (int)this.orglenLen);
                break;
            }
            case 131: {
                moveIndex = this.decoder.decoderWithCompressAndDecrypt(this.contetnBuffer, 4, buf.writeBuf.buff, buf.writeBuf.writePos, (int)this.compressSize, (int)this.orglenLen, this.aesCrypto);
                break;
            }
            case 130: {
                moveIndex = this.decoder.decoder(this.contetnBuffer, 0, buf.writeBuf.buff, buf.writeBuf.writePos, (int)this.orglenLen);
                break;
            }
            case 132: {
                moveIndex = this.decoder.decoderWithDecrypt(this.contetnBuffer, 0, buf.writeBuf.buff, buf.writeBuf.writePos, (int)this.orglenLen, this.aesCrypto);
                break;
            }
            default: {
                throw new Exception("drcnet exception: read unkonw type flag");
            }
        }
        if (moveIndex < 0) {
            throw new Exception("drcnet error: drcnet decoder failed");
        }
        buf.putData(moveIndex);
    }

    private void sendUserParam(ByteBuf temp, ChannelHandlerContext ctx, UserConfig userConfig, SyncState syncState, boolean isNewSync, boolean needEncrypt) throws Exception {
        if (isNewSync) {
            temp.writeByte(11);
            temp.writeInt(syncState.getConnType().getConnType());
        } else {
            temp.writeByte(2);
        }
        if (syncState.isMultiConn) {
            log.warn("multi conn started, not support");
            throw new Exception("multi conn started");
        }
        temp.writeByte(4);
        log.warn("single conn start");
        temp.writeInt((int)this.id);
        String urlString = userConfig.toUrlString();
        byte[] data = urlString.getBytes();
        if (needEncrypt && 0 > this.aesCrypto.encrypt(data, 0, data.length)) {
            throw new Exception("drcnet error: encrypt user data failed");
        }
        temp.writeInt(data.length);
        temp.writeBytes(data);
        ctx.channel().writeAndFlush((Object)temp);
    }

    private void checkPackLen(long len) throws Exception {
        if (len > 5000L) {
            throw new Exception("drcnet error: read unreasonable length");
        }
    }

    @Override
    public int initProcesser() {
        this.decoder = new lz4Decoder();
        this.tempIntBuf = new TempBuf();
        this.tempAuthStringBuf = new TempBuf();
        this.encryptBuf = new TempBuf();
        this.compressHeader = new byte[5];
        this.compressHeaderIndex = 0;
        this.aesCrypto = new AesCrypto();
        this.rsaCrypto = new RsaCrypto();
        if (this.decoder == null || this.compressHeader == null || null == this.rsaCrypto || null == this.aesCrypto) {
            return -1;
        }
        this.state = DRCNetCompressState.MAGIC_NUMBER;
        this.dataProcessState = DataProcessState.READ_HEAD;
        this.contentLen = 0L;
        this.orglenLen = 0L;
        this.leftData = 5L;
        return this.decoder.initDecoder() + this.tempIntBuf.initTempBuf(4) + this.tempAuthStringBuf.initTempBuf(25) + this.encryptBuf.initTempBuf(13);
    }

    private static enum RecvBufState {
        RECVING_SERVER_TOKEN_LEN,
        RECVING_RSA_PUBLIC_KEY_LEN,
        RECVING_SERVER_ENCRYPT_STRING_LEN,
        RECVING_SERVER_OK_STRING_LEN;

    }
}

