/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.check;

import com.aliyun.dts.subscribe.clients.check.CheckResult;
import com.aliyun.dts.subscribe.clients.check.SubscribeChecker;
import com.aliyun.dts.subscribe.clients.check.util.NetUtil;
import com.aliyun.dts.subscribe.clients.common.RetryUtil;
import java.util.concurrent.TimeUnit;

public class SubscribeNetworkChecker
implements SubscribeChecker {
    private String brokerUrl;
    private RetryUtil retryUtil;

    public SubscribeNetworkChecker(String brokerUrl) {
        this.brokerUrl = brokerUrl;
        this.retryUtil = new RetryUtil(4, TimeUnit.SECONDS, 15, e -> true);
    }

    @Override
    public CheckResult check() {
        boolean isOk = true;
        String errMsg = null;
        try {
            this.retryUtil.callFunctionWithRetry(() -> {
                int index = this.brokerUrl.lastIndexOf(":");
                String url = this.brokerUrl.substring(0, index);
                int port = Integer.parseInt(this.brokerUrl.substring(index + 1));
                NetUtil.testSocket(url, port);
            });
        }
        catch (Exception e) {
            isOk = false;
            errMsg = "telnet " + this.brokerUrl + " failed, please check the network and if the brokerUrl is correct";
        }
        return new CheckResult(isOk, errMsg);
    }
}

