/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.cyberway.msf.commons.api.annotations.ResponseResultCode;
import com.cyberway.msf.commons.api.annotations.ResponseResultCodes;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.readers.operation.SwaggerResponseMessageReader;

@Component
@Order(value=-2147482647)
public class ApiResultCodeReader
extends SwaggerResponseMessageReader {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<Class<? extends ApiResultCode>, Map<String, ApiResultCode>> codeClassMap = new HashMap<Class<? extends ApiResultCode>, Map<String, ApiResultCode>>();

    @Autowired
    public ApiResultCodeReader(TypeNameExtractor typeNameExtractor, TypeResolver typeResolver) {
        super(typeNameExtractor, typeResolver);
    }

    public void apply(OperationContext context) {
        Optional responseResultCodeAnnotation = context.findAnnotation(ResponseResultCode.class);
        Optional responseResultCodesAnnotation = context.findAnnotation(ResponseResultCodes.class);
        HashMap<Integer, String> resultCodeMessageMap = new HashMap<Integer, String>(16);
        if (responseResultCodeAnnotation.isPresent() && ((ResponseResultCode)responseResultCodeAnnotation.get()).value().length > 0) {
            this.handleResponseResultCode(resultCodeMessageMap, (ResponseResultCode)responseResultCodeAnnotation.get());
        }
        if (responseResultCodesAnnotation.isPresent() && ((ResponseResultCodes)responseResultCodesAnnotation.get()).value().length > 0) {
            ResponseResultCode[] responseResultCodes;
            for (ResponseResultCode responseResultCode : responseResultCodes = ((ResponseResultCodes)responseResultCodesAnnotation.get()).value()) {
                this.handleResponseResultCode(resultCodeMessageMap, responseResultCode);
            }
        }
        if (!resultCodeMessageMap.isEmpty()) {
            Set messageSet = this.read(context);
            HashSet<ResponseMessage> newMessageSet = new HashSet<ResponseMessage>();
            for (ResponseMessage responseMessage : messageSet) {
                if (!resultCodeMessageMap.containsKey(responseMessage.getCode())) continue;
                newMessageSet.add(new ResponseMessage(responseMessage.getCode(), responseMessage.getMessage() + (String)resultCodeMessageMap.get(responseMessage.getCode()), responseMessage.getResponseModel(), responseMessage.getHeaders(), responseMessage.getVendorExtensions()));
            }
            if (!newMessageSet.isEmpty()) {
                messageSet.removeAll(newMessageSet);
                messageSet.addAll(newMessageSet);
                context.operationBuilder().responseMessages(messageSet);
            }
        }
    }

    private void handleResponseResultCode(Map<Integer, String> resultCodeMessageMap, ResponseResultCode responseResultCode) {
        HashMap<String, ApiResultCode> apiResultCodeMap;
        boolean state;
        boolean bl = state = (!responseResultCode.showGlobal() || responseResultCode.global().length == 0) && responseResultCode.value().length == 0;
        if (state) {
            return;
        }
        Class<? extends ApiResultCode> codeClass = responseResultCode.codeClass();
        if (!this.codeClassMap.containsKey(codeClass)) {
            Field[] fields;
            apiResultCodeMap = new HashMap(16);
            for (Field field : fields = codeClass.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !ApiResultCode.class.isAssignableFrom(field.getType())) continue;
                try {
                    ApiResultCode apiResultCode = (ApiResultCode)field.get(codeClass);
                    apiResultCodeMap.put(field.getName(), apiResultCode);
                }
                catch (IllegalAccessException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.codeClassMap.put(codeClass, apiResultCodeMap);
        }
        apiResultCodeMap = this.codeClassMap.get(codeClass);
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("\r\n\u8fd4\u56de\u7ed3\u679c\u7801\u5217\u8868:\r\n");
        if (responseResultCode.showGlobal()) {
            this.appendCodeMessage(messageBuilder, apiResultCodeMap, responseResultCode.global());
        }
        this.appendCodeMessage(messageBuilder, apiResultCodeMap, responseResultCode.value());
        resultCodeMessageMap.put(responseResultCode.statusCode(), messageBuilder.toString());
    }

    private void appendCodeMessage(StringBuilder messageBuilder, Map<String, ApiResultCode> apiResultCodeMap, String[] codes) {
        for (String code : codes) {
            if (apiResultCodeMap.containsKey(code)) {
                ApiResultCode apiResultCode = apiResultCodeMap.get(code);
                messageBuilder.append(apiResultCode.getResultCode());
                messageBuilder.append(":");
                messageBuilder.append(apiResultCode.getResultMessage());
                messageBuilder.append("\r\n");
                continue;
            }
            this.logger.warn("Unknown result code:{}", (Object)code);
        }
    }
}

