/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.api.result;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

@ApiModel(value="\u63a5\u53e3\u54cd\u5e94\u5c01\u88c5\u7c7b")
public class ApiResponseResult<T> {
    @ApiModelProperty(value="\u7ed3\u679c\u7801, \u8868\u793a\u63a5\u53e3\u5904\u7406\u7ed3\u679c\u72b6\u6001")
    private String resultCode;
    @ApiModelProperty(value="\u7ed3\u679c\u4fe1\u606f, \u63cf\u8ff0\u63a5\u53e3\u5904\u7406\u7ed3\u679c")
    private String resultMessage;
    @ApiModelProperty(value="\u7ed3\u679c\u6570\u636e, \u63a5\u53e3\u5904\u7406\u6210\u529f\u65f6\u8fd4\u56de\u7684\u4e1a\u52a1\u6570\u636e")
    private T data;
    private static final Pattern MODEL_ERROR_CODE_PATTERN = Pattern.compile("^[1-9][0-9]{8}$");
    private static final ObjectMapper mapper = new ObjectMapper();

    public ApiResponseResult() {
    }

    public ApiResponseResult(T data) {
        this(ApiResultCode.SUCCESS.getResultCode(), ApiResultCode.SUCCESS.getResultMessage(), data);
    }

    public ApiResponseResult(ApiResultCode apiResultCode) {
        this(apiResultCode.getResultCode(), apiResultCode.getResultMessage(), null);
    }

    public ApiResponseResult(ApiResultCode apiResultCode, T data) {
        this(apiResultCode.getResultCode(), apiResultCode.getResultMessage(), data);
    }

    public ApiResponseResult(String resultCode, String resultMessage, T data) {
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
        this.data = data;
    }

    public ApiResponseResult(String resultCode, String resultMessage) {
        this(resultCode, resultMessage, null);
    }

    public static <T> ApiResponseResult<T> buildByApiResultCode(ApiResultCode apiResultCode, Object ... messageArgs) {
        return new ApiResponseResult<Object>(apiResultCode.getResultCode(), messageArgs != null ? String.format(apiResultCode.getResultMessage(), messageArgs) : apiResultCode.getResultMessage(), null);
    }

    public static <T> ApiResponseResult<T> buildByBindingResult(BindingResult bindingResult) {
        if (bindingResult.hasGlobalErrors()) {
            String errorCode;
            ObjectError globalError = bindingResult.getGlobalError();
            String string = errorCode = globalError == null ? null : globalError.getCode();
            if (StringUtils.isNotBlank((CharSequence)errorCode) && MODEL_ERROR_CODE_PATTERN.matcher(errorCode).matches()) {
                return new ApiResponseResult<T>(errorCode, StringUtils.defaultString((String)globalError.getDefaultMessage()));
            }
        } else if (bindingResult.hasFieldErrors()) {
            FieldError fieldError = bindingResult.getFieldError();
            if (fieldError == null) {
                return new ApiResponseResult<T>(null);
            }
            String errorCode = fieldError.getCode();
            if (StringUtils.isNotBlank((CharSequence)errorCode) && MODEL_ERROR_CODE_PATTERN.matcher(errorCode).matches()) {
                return new ApiResponseResult<T>(errorCode, StringUtils.defaultString((String)fieldError.getDefaultMessage()));
            }
            return new ApiResponseResult<Object>(ApiResultCode.INVALID_PARAM_VALUE.getResultCode(), String.format(ApiResultCode.INVALID_PARAM_VALUE.getResultMessage(), fieldError.getField(), StringUtils.defaultString((String)fieldError.getDefaultMessage())), null);
        }
        return new ApiResponseResult<T>(null);
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public T getData() {
        return this.data;
    }

    public T getData(Class<T> clz) {
        return this.data instanceof Map ? this.fromMap((Map)this.data, clz) : this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private T fromMap(Map<?, ?> map, Class<T> t) {
        if (map == null) {
            return null;
        }
        try {
            String jsonString = mapper.writeValueAsString(map);
            return (T)mapper.readValue(jsonString, t);
        }
        catch (Exception e) {
            return null;
        }
    }
}

