/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.service.impl;

import com.cyberway.msf.commons.auth.model.SignType;
import com.cyberway.msf.commons.auth.service.ApiAuthenticationService;
import com.cyberway.msf.commons.auth.support.CommonsAuthProperties;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiAuthenticationServiceImpl
implements ApiAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(ApiAuthenticationServiceImpl.class);
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsAuthProperties commonsAuthProperties;
    private static final String HMAC = "Hmac";
    private static final String UTF_8 = "utf-8";
    private static final Long SECOND = 1000L;

    @Override
    public String generateToke(String uid) {
        return this.jwtUtils.getToken(uid);
    }

    @Override
    public String generateToke(String uid, Integer expireTime) {
        return this.jwtUtils.getToken(uid, expireTime);
    }

    @Override
    public JwtUtils.JwtResult authenticateTokenResult(String token) {
        return this.jwtUtils.checkToken(token);
    }

    @Override
    public Boolean authenticateToken(String token) {
        Boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)token)) {
            isValid = false;
        } else if (!this.authenticateTokenResult(token).isSuccess()) {
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String signature(String apiKey, String nonceStr, Long timestamp, String data) {
        return this.signature(apiKey, nonceStr, timestamp, data, SignType.MD5);
    }

    @Override
    public String signature(String apiKey, String nonceStr, Long timestamp, String data, SignType signType) {
        return this.signatureWithHmac(apiKey, nonceStr, timestamp, data, null, signType);
    }

    @Override
    public String signatureWithHmac(String apiKey, String nonceStr, Long timestamp, String data, String apiSecret, SignType signType) {
        String sign = "";
        if (StringUtils.contains((CharSequence)signType.getName(), (CharSequence)HMAC) && StringUtils.isEmpty((CharSequence)apiSecret)) {
            logger.error("SignType {} requires secretKey.", (Object)signType.getName());
            throw new BaseException(String.format("SignType %s requires secretKey.", signType.getName()));
        }
        String content = this.getSignatureContent(apiKey, nonceStr, timestamp, data);
        switch (signType) {
            case MD5: {
                sign = this.sign(content, SignType.MD5.getName());
                break;
            }
            case SHA1: {
                sign = this.sign(content, SignType.SHA1.getName());
                break;
            }
            case SHA256: {
                sign = this.sign(content, SignType.SHA256.getName());
                break;
            }
            case HMAC_MD5: {
                sign = this.hmacSign(content, apiSecret, SignType.HMAC_MD5.getName());
                break;
            }
            case HMAC_SHA1: {
                sign = this.hmacSign(content, apiSecret, SignType.HMAC_SHA1.getName());
                break;
            }
            case HMAC_SHA256: {
                sign = this.hmacSign(content, apiSecret, SignType.HMAC_SHA256.getName());
                break;
            }
            default: {
                sign = this.sign(content, SignType.MD5.getName());
            }
        }
        return sign;
    }

    @Override
    public Boolean signatureCheck(Map<String, Object> content) {
        Long timestamp = Long.parseLong(String.valueOf(content.get("timestamp")));
        if (System.currentTimeMillis() - timestamp >= this.commonsAuthProperties.getApiTime() * SECOND) {
            throw new BaseException("Sign is expired.");
        }
        String apiKey = String.valueOf(content.get("apiKey"));
        String nonceStr = String.valueOf(content.get("nonceStr"));
        String data = String.valueOf(content.get("data"));
        String apiSecret = String.valueOf(content.get("apiSecret"));
        String signType = String.valueOf(content.get("signType"));
        String sign = String.valueOf(content.get("sign"));
        return StringUtils.equals((CharSequence)sign, (CharSequence)this.signatureWithHmac(apiKey, nonceStr, timestamp, data, apiSecret, SignType.valueOf(signType)));
    }

    @Override
    public Boolean signatureCheckWithToken(Map<String, Object> content) {
        String token = String.valueOf(content.get("token"));
        content.remove("token");
        return this.signatureCheck(content) != false && this.authenticateToken(token) != false;
    }

    @Override
    public Boolean signatureCheck(String content) {
        Map<String, Object> map = this.getContentMap(content);
        return this.signatureCheck(map);
    }

    @Override
    public Boolean signatureCheckWithToken(String content) {
        Map<String, Object> map = this.getContentMap(content);
        return this.signatureCheckWithToken(map);
    }

    private String getSignatureContent(String apiKey, String nonceStr, Long timestamp, String data) {
        StringBuilder sb = new StringBuilder();
        sb.append("apiKey").append("=").append(apiKey).append("&").append("nonceStr").append("=").append(nonceStr).append("&").append("timestamp").append("=").append(timestamp).append("&").append("data").append("=").append(data);
        return sb.toString();
    }

    private Map<String, Object> getContentMap(String content) {
        String[] params;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (String param : params = StringUtils.split((String)content, (String)"&")) {
            String[] values = StringUtils.split((String)param, (String)"=");
            if (values.length <= 1) continue;
            map.put(values[0], values[1]);
        }
        return map;
    }

    private String sign(String content, String signType) {
        String sign = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance(signType);
            byte[] bytes = md5.digest(content.getBytes(UTF_8));
            sign = this.encodeBytes(bytes);
        }
        catch (Exception e) {
            logger.error("{} signature fail.", (Object)signType);
            throw new BaseException(String.format("%s signature fail.", signType), (Throwable)e);
        }
        return sign;
    }

    private String hmacSign(String content, String apiSecret, String signType) {
        String sign;
        try {
            Mac hmac = Mac.getInstance(signType);
            SecretKeySpec secretKey = new SecretKeySpec(apiSecret.getBytes(UTF_8), signType);
            hmac.init(secretKey);
            byte[] bytes = hmac.doFinal(content.getBytes(UTF_8));
            sign = this.encodeBytes(bytes);
        }
        catch (Exception e) {
            logger.error("{} signature fail.", (Object)signType);
            throw new BaseException(String.format("%s signature fail.", signType), (Throwable)e);
        }
        return sign;
    }

    private String encodeBytes(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().toUpperCase();
    }
}

