/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.auth.model.AppSignInfo;
import com.cyberway.msf.commons.auth.model.SignType;
import com.cyberway.msf.commons.auth.service.ApiAuthenticationService;
import com.cyberway.msf.commons.auth.support.CommonsAuthProperties;
import com.cyberway.msf.commons.auth.util.AuthUtils;
import com.cyberway.msf.commons.auth.util.JwtUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.util.LongUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Service;

@Service
public class ApiAuthenticationServiceImpl
implements ApiAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(ApiAuthenticationServiceImpl.class);
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private CommonsAuthProperties commonsAuthProperties;
    @Autowired
    private RedisUtils redisUtils;
    private static final String HMAC = "Hmac";
    private static final Long SECOND = 1000L;

    @Override
    public String generateToke(String uid) {
        return this.jwtUtils.getToken(uid);
    }

    @Override
    public String generateToke(String uid, Integer expireTime) {
        return this.jwtUtils.getToken(uid, expireTime);
    }

    @Override
    public JwtUtils.JwtResult authenticateTokenResult(String token) {
        return this.jwtUtils.checkToken(token);
    }

    @Override
    public Boolean authenticateToken(String token) {
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)token)) {
            isValid = false;
        } else if (!this.authenticateTokenResult(token).isSuccess()) {
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String signature(String apiKey, String nonceStr, Long timestamp, String data) {
        return this.signature(apiKey, nonceStr, timestamp, data, SignType.MD5);
    }

    @Override
    public String signature(String apiKey, String nonceStr, Long timestamp, String data, SignType signType) {
        return this.signatureWithHmac(apiKey, nonceStr, timestamp, data, null, signType);
    }

    @Override
    public String signatureWithHmac(String apiKey, String nonceStr, Long timestamp, String data, String apiSecret, SignType signType) {
        String sign = "";
        if (StringUtils.contains((CharSequence)signType.getName(), (CharSequence)HMAC) && StringUtils.isEmpty((CharSequence)apiSecret)) {
            logger.error("SignType {} requires secretKey.", (Object)signType.getName());
            throw new BaseException(String.format("SignType %s requires secretKey.", signType.getName()));
        }
        String content = this.getSignatureContent(apiKey, nonceStr, timestamp, data);
        return this.sign(content, signType, apiSecret);
    }

    private String sign(String signBaseString, SignType signType, String appSecret) {
        switch (signType) {
            case SHA1: {
                return this.sign(signBaseString, SignType.SHA1.getName());
            }
            case SHA256: {
                return this.sign(signBaseString, SignType.SHA256.getName());
            }
            case HMAC_MD5: {
                return this.hmacSign(signBaseString, appSecret, SignType.HMAC_MD5.getName());
            }
            case HMAC_SHA1: {
                return this.hmacSign(signBaseString, appSecret, SignType.HMAC_SHA1.getName());
            }
            case HMAC_SHA256: {
                return this.hmacSign(signBaseString, appSecret, SignType.HMAC_SHA256.getName());
            }
        }
        return this.sign(signBaseString, SignType.MD5.getName());
    }

    @Override
    public Boolean signatureCheck(Map<String, Object> content) {
        long timestamp = Long.parseLong(String.valueOf(content.get("timestamp")));
        if (System.currentTimeMillis() - timestamp >= this.commonsAuthProperties.getApiTime() * SECOND) {
            throw new BaseException("Sign is expired.");
        }
        String apiKey = String.valueOf(content.get("apiKey"));
        String nonceStr = String.valueOf(content.get("nonceStr"));
        String data = String.valueOf(content.get("data"));
        String apiSecret = String.valueOf(content.get("apiSecret"));
        String signType = String.valueOf(content.get("signType"));
        String sign = String.valueOf(content.get("sign"));
        return StringUtils.equals((CharSequence)sign, (CharSequence)this.signatureWithHmac(apiKey, nonceStr, timestamp, data, apiSecret, SignType.valueOf(signType)));
    }

    @Override
    public AppSignInfo loadAppSignInfo(HttpRequest request) {
        List appKeys = request.getHeaders().get((Object)"auth-app-key");
        if (appKeys == null || appKeys.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)appKeys.get(0)))) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7f3a\u5c11auth-app-key\u8bf7\u6c42\u5934");
        }
        return this.loadAppSignInfo((String)appKeys.get(0));
    }

    @Override
    public AppSignInfo loadAppSignInfo(String appKey) {
        String signInfoJson = (String)this.redisUtils.getHashOrigin("appAuthInfo", (Object)appKey);
        if (StringUtils.isBlank((CharSequence)signInfoJson)) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u65e0\u6548\u7684auth-app-key");
        }
        return (AppSignInfo)JSON.parseObject((String)signInfoJson, AppSignInfo.class);
    }

    @Override
    public AppSignInfo checkApiRequestSimpleMode(HttpRequest request) {
        Date now = new Date();
        HttpHeaders headers = request.getHeaders();
        List appKeys = headers.get((Object)"auth-app-key");
        if (appKeys == null || appKeys.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)appKeys.get(0)))) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7f3a\u5c11auth-app-key\u8bf7\u6c42\u5934");
        }
        String appKey = (String)appKeys.get(0);
        AppSignInfo appSignInfo = this.loadAppSignInfo(appKey);
        if (appSignInfo.getExpirationStartDate() != null && appSignInfo.getExpirationStartDate().after(now) || appSignInfo.getExpirationEndDate() != null && appSignInfo.getExpirationEndDate().before(now)) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u65e0\u6548\u7684auth-app-key");
        }
        if (!AuthUtils.checkApiList(request, appSignInfo.getApiList())) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u65e0\u6743\u8bf7\u6c42\u8be5\u63a5\u53e3");
        }
        List timestamps = headers.get((Object)"auth-timestamp");
        if (timestamps == null || timestamps.isEmpty()) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7f3a\u5c11auth-timestamp\u8bf7\u6c42\u5934");
        }
        Long timestamp = LongUtils.tryStringToLong((String)((String)timestamps.get(0)));
        if (timestamp == null) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u65e0\u6548\u683c\u5f0f\u7684auth-timestamp\u8bf7\u6c42\u5934");
        }
        if (Math.abs(now.getTime() - timestamp) >= this.commonsAuthProperties.getApiTime() * SECOND) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u8d85\u8fc7\u6709\u6548\u65f6\u95f4\u8303\u56f4\u7684auth-timestamp\u8bf7\u6c42\u5934");
        }
        List nonces = headers.get((Object)"auth-nonce");
        if (nonces == null || nonces.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)nonces.get(0)))) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7f3a\u5c11auth-nonce\u8bf7\u6c42\u5934");
        }
        String nonce = (String)nonces.get(0);
        List signatures = headers.get((Object)"auth-signature");
        if (signatures == null || signatures.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)signatures.get(0)))) {
            throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7f3a\u5c11auth-signature\u8bf7\u6c42\u5934");
        }
        String signature = (String)signatures.get(0);
        if (signature.equals(this.signApiRequestSimpleMode(request.getURI().getPath(), appKey, appSignInfo.getSignType(), appSignInfo.getAppSecret(), nonce, timestamp))) {
            return appSignInfo;
        }
        throw new BaseException(ApiResultCode.PERMISSION_DENIED.getResultCode(), "\u7b7e\u540d\u65e0\u6548");
    }

    @Override
    public String signApiRequestSimpleMode(String requestPath, String appKey, SignType signType, String appSecret, String nonce, long timestamp) {
        String signBaseString = requestPath + "&appKey=" + appKey + "&nonce=" + nonce + "&timestamp=" + LongUtils.longToString((Long)timestamp);
        return this.sign(signBaseString, signType, appSecret);
    }

    @Override
    public Boolean signatureCheckWithToken(Map<String, Object> content) {
        String token = String.valueOf(content.get("token"));
        content.remove("token");
        return this.signatureCheck(content) != false && this.authenticateToken(token) != false;
    }

    @Override
    public Boolean signatureCheck(String content) {
        Map<String, Object> map = this.getContentMap(content);
        return this.signatureCheck(map);
    }

    @Override
    public Boolean signatureCheckWithToken(String content) {
        Map<String, Object> map = this.getContentMap(content);
        return this.signatureCheckWithToken(map);
    }

    private String getSignatureContent(String apiKey, String nonceStr, Long timestamp, String data) {
        StringBuilder sb = new StringBuilder();
        sb.append("apiKey").append("=").append(apiKey).append("&").append("nonceStr").append("=").append(nonceStr).append("&").append("timestamp").append("=").append(timestamp).append("&").append("data").append("=").append(data);
        return sb.toString();
    }

    private Map<String, Object> getContentMap(String content) {
        String[] params;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (String param : params = StringUtils.split((String)content, (String)"&")) {
            String[] values = StringUtils.split((String)param, (String)"=");
            if (values.length <= 1) continue;
            map.put(values[0], values[1]);
        }
        return map;
    }

    private String sign(String content, String signType) {
        String sign = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance(signType);
            byte[] bytes = md5.digest(content.getBytes(StandardCharsets.UTF_8));
            sign = this.encodeBytes(bytes);
        }
        catch (Exception e) {
            logger.error("{} signature fail.", (Object)signType);
            throw new BaseException(String.format("%s signature fail.", signType), (Throwable)e);
        }
        return sign;
    }

    private String hmacSign(String content, String apiSecret, String signType) {
        String sign;
        try {
            Mac hmac = Mac.getInstance(signType);
            SecretKeySpec secretKey = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), signType);
            hmac.init(secretKey);
            byte[] bytes = hmac.doFinal(content.getBytes(StandardCharsets.UTF_8));
            sign = this.encodeBytes(bytes);
        }
        catch (Exception e) {
            logger.error("{} signature fail.", (Object)signType);
            throw new BaseException(String.format("%s signature fail.", signType), (Throwable)e);
        }
        return sign;
    }

    private String encodeBytes(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().toUpperCase();
    }
}

