/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.AntPathMatcher;

public class AuthUtils {
    private static final Map<String, HttpMethod> METHOD_MAP = new HashMap<String, HttpMethod>();
    private static final AntPathMatcher URL_MATCHER = new AntPathMatcher();

    private AuthUtils() {
    }

    public static boolean checkApiList(HttpRequest request, Collection<String> apiList) {
        return AuthUtils.checkApiList(request.getMethod(), request.getURI().getPath(), apiList);
    }

    public static boolean checkApiList(HttpMethod httpMethod, String requestPath, Collection<String> apiList) {
        if (apiList == null) {
            return false;
        }
        for (String api : apiList) {
            if (!AuthUtils.checkMatchPath(api, requestPath, httpMethod)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMatchPath(String path, String requestPath, HttpMethod httpMethod) {
        String method;
        String[] paths = path.split(":", 2);
        if (paths.length > 1 && METHOD_MAP.containsKey(method = paths[0].toUpperCase())) {
            if (!Objects.equals(httpMethod, METHOD_MAP.get(method))) {
                return false;
            }
            path = paths[1];
        }
        return URL_MATCHER.match(path, requestPath);
    }

    static {
        URL_MATCHER.setCachePatterns(true);
        for (HttpMethod httpMethod : HttpMethod.values()) {
            METHOD_MAP.put(httpMethod.name(), httpMethod);
        }
    }
}

