/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.util;

import com.cyberway.msf.commons.auth.util.RsaUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtils.class);
    private final RsaUtils rsaUtils = new RsaUtils();

    public String getToken(String subject) {
        return this.getToken(subject, null, 10080L);
    }

    public String getToken(String subject, Map<String, Object> claims) {
        return this.getToken(subject, claims, 10080L);
    }

    public String getToken(String subject, long expireMinutes) {
        return this.getToken(subject, null, expireMinutes);
    }

    public String getToken(String subject, Map<String, Object> claims, long expireMinutes) {
        long endTime = new Date().getTime() + 60000L * expireMinutes;
        try {
            JwtBuilder builder = Jwts.builder().setSubject(subject);
            if (null != claims && !claims.isEmpty()) {
                claims.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
            }
            return builder.setExpiration(new Date(endTime)).signWith(SignatureAlgorithm.RS256, (Key)this.rsaUtils.getPrivateKey("key/pri.key")).compact();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            logger.error("Generate RSA key error! message: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public JwtResult checkToken(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)this.rsaUtils.getPublicKey("key/pub.key")).parseClaimsJws(token).getBody();
            String sub = (String)claims.get("sub", String.class);
            logger.debug("token.sub : {} ", (Object)sub);
            return new JwtResult(true, sub, "\u5408\u6cd5\u8bf7\u6c42", HttpStatus.OK.value());
        }
        catch (ExpiredJwtException e) {
            return new JwtResult(false, (String)e.getClaims().get("sub", String.class), "token\u5df2\u8fc7\u671f", HttpStatus.PAYMENT_REQUIRED.value());
        }
        catch (Exception e) {
            return new JwtResult(false, null, "\u975e\u6cd5\u8bf7\u6c42", HttpStatus.FORBIDDEN.value());
        }
    }

    public Object resloveToken(String token, String claim) {
        try {
            Claims body = (Claims)Jwts.parser().setSigningKey((Key)this.rsaUtils.getPublicKey("key/pub.key")).parseClaimsJws(token).getBody();
            return body.get((Object)claim);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public static class JwtResult {
        private boolean status;
        private String uid;
        private String msg;
        private int code;

        public JwtResult(boolean status, String uid, String msg, int code) {
            this.status = status;
            this.uid = uid;
            this.msg = msg;
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean isSuccess() {
            return this.status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String toString() {
            return "JwtResult [status=" + this.status + ", uid=" + this.uid + ", msg=" + this.msg + ", code=" + this.code + "]";
        }
    }
}

