/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.support.password;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.auth.support.CommonsPasswordProperties;
import com.cyberway.msf.commons.auth.support.password.PasswordTransfer;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

public class AesPasswordTransfer
implements PasswordTransfer {
    private final CommonsPasswordProperties passwordProperties;

    public AesPasswordTransfer(CommonsPasswordProperties passwordProperties) {
        this.passwordProperties = passwordProperties;
    }

    @Override
    public String encodePassword(String rawPassword) {
        if (StringUtils.isBlank((CharSequence)rawPassword)) {
            return rawPassword;
        }
        byte[] byteContent = rawPassword.getBytes(StandardCharsets.UTF_8);
        try {
            Cipher encryptCipher = this.getCipher(1);
            byte[] resultBytes = encryptCipher.doFinal(byteContent);
            return Base64Utils.encodeToString((byte[])resultBytes);
        }
        catch (Exception e) {
            throw new BaseException(ApiResultCode.INVALID_ENCODE_PASSWORD.getResultCode(), ApiResultCode.INVALID_ENCODE_PASSWORD.getResultMessage());
        }
    }

    @Override
    public String decodePassword(String sourcePassword) {
        if (StringUtils.isBlank((CharSequence)sourcePassword)) {
            return sourcePassword;
        }
        try {
            byte[] byteContent = Base64Utils.decodeFromString((String)sourcePassword);
            Cipher decryptCipher = this.getCipher(2);
            byte[] resultBytes = decryptCipher.doFinal(byteContent);
            return new String(resultBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new BaseException(ApiResultCode.INVALID_DECODE_PASSWORD.getResultCode(), ApiResultCode.INVALID_DECODE_PASSWORD.getResultMessage());
        }
    }

    private Cipher getCipher(int mode) throws Exception {
        byte[] password = this.passwordProperties.getAes().getKey().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec key = new SecretKeySpec(password, "AES");
        IvParameterSpec iv = new IvParameterSpec(password);
        Cipher cipher = Cipher.getInstance(this.passwordProperties.getAes().getAlgorithm());
        cipher.init(mode, (Key)key, iv);
        return cipher;
    }
}

