/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.support.password;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.auth.support.CommonsPasswordProperties;
import com.cyberway.msf.commons.auth.support.password.PasswordTransfer;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;

public class RsaPasswordTransfer
implements PasswordTransfer {
    private static final String ALGORITHM = "RSA";
    private final CommonsPasswordProperties passwordProperties;

    public RsaPasswordTransfer(CommonsPasswordProperties passwordProperties) {
        this.passwordProperties = passwordProperties;
    }

    @Override
    public String encodePassword(String rawPassword) {
        try {
            byte[] byteKey = Base64Utils.decodeFromString((String)this.passwordProperties.getRsa2().getPrivateKey());
            PublicKey publicKey = KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(byteKey));
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, publicKey);
            return Base64Utils.encodeToString((byte[])cipher.doFinal(rawPassword.getBytes()));
        }
        catch (Exception e) {
            throw new BaseException(ApiResultCode.INVALID_DECODE_PASSWORD.getResultCode(), ApiResultCode.INVALID_DECODE_PASSWORD.getResultMessage());
        }
    }

    @Override
    public String decodePassword(String sourcePassword) {
        if (StringUtils.isBlank((CharSequence)sourcePassword)) {
            return sourcePassword;
        }
        try {
            byte[] byteContent = Base64Utils.decodeFromString((String)sourcePassword);
            byte[] byteKey = Base64Utils.decodeFromString((String)this.passwordProperties.getRsa2().getPrivateKey());
            PrivateKey privateKey = KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(byteKey));
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(byteContent));
        }
        catch (Exception e) {
            throw new BaseException(ApiResultCode.INVALID_DECODE_PASSWORD.getResultCode(), ApiResultCode.INVALID_DECODE_PASSWORD.getResultMessage());
        }
    }
}

