/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.auth.support.password;

import com.cyberway.msf.commons.auth.support.CommonsPasswordProperties;
import com.cyberway.msf.commons.auth.support.password.AesPasswordTransfer;
import com.cyberway.msf.commons.auth.support.password.BCryptPasswordEncoder;
import com.cyberway.msf.commons.auth.support.password.Md5PasswordTransfer;
import com.cyberway.msf.commons.auth.support.password.PasswordEncoder;
import com.cyberway.msf.commons.auth.support.password.PasswordService;
import com.cyberway.msf.commons.auth.support.password.PasswordTransfer;
import com.cyberway.msf.commons.auth.support.password.RsaPasswordTransfer;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class PasswordServiceImpl
implements PasswordService {
    private final CommonsPasswordProperties passwordProperties;
    private final PasswordEncoder passwordEncoder;
    private final PasswordTransfer passwordTransfer;

    public PasswordServiceImpl(CommonsPasswordProperties passwordProperties) {
        this.passwordProperties = passwordProperties;
        this.passwordEncoder = this.getPasswordEncoder();
        this.passwordTransfer = this.getPasswordTransfer();
    }

    protected PasswordEncoder getPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected PasswordTransfer getPasswordTransfer() {
        if (CommonsPasswordProperties.TransferType.AES.getName().equalsIgnoreCase(this.passwordProperties.getTransfer())) {
            return new AesPasswordTransfer(this.passwordProperties);
        }
        if (CommonsPasswordProperties.TransferType.RSA2.getName().equalsIgnoreCase(this.passwordProperties.getTransfer())) {
            return new RsaPasswordTransfer(this.passwordProperties);
        }
        return new Md5PasswordTransfer();
    }

    @Override
    public String encode(String rawPassword) {
        return this.passwordEncoder.encode(rawPassword);
    }

    @Override
    public boolean matches(String rawPassword, String encodedPassword) {
        return this.passwordEncoder.matches(rawPassword, encodedPassword);
    }

    @Override
    public String encodeMd5RawPassword(String rawPassword) {
        String md5Password = DigestUtils.md5DigestAsHex((byte[])rawPassword.getBytes());
        return this.encode(md5Password);
    }

    @Override
    public String encodeMd5Password(String decodePassword) {
        String md5Password = decodePassword;
        if (!this.passwordTransfer.canDecode()) {
            md5Password = DigestUtils.md5DigestAsHex((byte[])decodePassword.getBytes());
        }
        return this.encode(md5Password);
    }

    @Override
    public boolean matchesMd5Password(String decodePassword, String encodedPassword) {
        String md5Password = decodePassword;
        if (!this.passwordTransfer.canDecode()) {
            md5Password = DigestUtils.md5DigestAsHex((byte[])decodePassword.getBytes());
        }
        return this.matches(md5Password, encodedPassword);
    }

    @Override
    public String decodeSourcePassword(String sourcePassword) {
        return this.passwordTransfer.decodePassword(sourcePassword);
    }

    @Override
    public String encodeSourcePassword(String rawPassword) {
        return this.passwordTransfer.encodePassword(rawPassword);
    }
}

