/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.util.JsonUtils;
import com.cyberway.msf.ms.model.mq.dto.MqDto;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MqUtils {
    @Autowired
    private AmqpTemplate rabbitTemplate;
    private static MqUtils mqUtils;

    @PostConstruct
    public void init() {
        mqUtils = this;
    }

    public static void sendMessage(String exchange, String routingKey, Object body) {
        MqDto mq = new MqDto();
        mq.setBody(body);
        mq.setExchange(exchange);
        mq.setRoutingKey(routingKey);
        MqUtils.sendMessage(mq);
    }

    public static void sendMessage(MqDto mq) {
        MqUtils.mqUtils.rabbitTemplate.convertAndSend(mq.getExchange(), mq.getRoutingKey(), (Object)JsonUtils.toJson(mq.getBody()));
    }
}

