/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.support.annotation.log.BusinessLogEvent;
import com.cyberway.msf.commons.base.support.annotation.log.DataChangeLogEvent;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BusinessLog;
import com.cyberway.msf.log.model.DataChangeLog;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    @Autowired(required=false)
    private FrameworkEventService frameworkEventService;
    @Autowired(required=false)
    private CommonsBaseProperties commonsBaseProperties;
    private static LogUtils logUtils;

    @PostConstruct
    public void init() {
        logUtils = this;
    }

    public static void log(String content, String tag) {
        String fromIp = "";
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fromIp = IpUtils.getRemoteAddr(request);
        }
        BusinessLog log = new BusinessLog();
        log.setContent(content);
        log.setFromIp(fromIp);
        log.setCreateTime(new Date());
        log.setModule(tag);
        UserInfo userInfo = UserUtils.getLoggedInUser();
        log.setCreateBy(userInfo == null ? null : userInfo.getUsername());
        log.setCreateById(userInfo == null ? null : (Long)userInfo.getId());
        if (LogUtils.logUtils.commonsBaseProperties != null && LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent);
        }
    }

    public static void logDataChange(DataChangeLog dataChangeLog) {
        if (LogUtils.logUtils.commonsBaseProperties != null && LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Log data change of table [{}], data id [{}], long data id [{}], sql type [{}]", new Object[]{dataChangeLog.getTableName(), dataChangeLog.getDataId(), dataChangeLog.getLongDataId(), dataChangeLog.getSqlType()});
            }
            DataChangeLogEvent dataChangeLogEvent = new DataChangeLogEvent();
            dataChangeLogEvent.setData(dataChangeLog);
            LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)dataChangeLogEvent);
        }
    }
}

