/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.support.annotation.log.BusinessLogEvent;
import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BusinessLog;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    @Autowired(required=false)
    private FrameworkEventService frameworkEventService;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;

    @Pointcut(value="execution(@com.cyberway.msf.commons.base.support.annotation.log.LogRequired * *(..))")
    public void log() {
    }

    @AfterReturning(value="log() && @annotation(logRequired)", returning="ret")
    public void doAfterReturning(LogRequired logRequired, Object ret) throws BaseException {
        UserInfo userInfo;
        String content = logRequired.content();
        if (null != ret) {
            String phraseStr;
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("ret", ret);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(logRequired.content());
            content = phraseStr = (String)exp.getValue((EvaluationContext)context);
        }
        String fromIp = "";
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            fromIp = request.getRemoteAddr();
        }
        BusinessLog log = new BusinessLog();
        log.setContent(content);
        log.setFromIp(fromIp);
        log.setCreateTime(new Date());
        log.setModule(logRequired.module().getCode());
        if (StringUtils.isNotBlank((CharSequence)logRequired.tag())) {
            log.setModule(logRequired.tag());
        }
        log.setCreateBy((userInfo = UserUtils.getLoggedInUser()) == null ? null : userInfo.getUsername());
        if (this.commonsBaseProperties.getLogEnable().booleanValue()) {
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            this.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent);
        }
    }
}

