/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.converter;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.support.converter.ErrorCodeConverter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@ConditionalOnMissingBean(value={ErrorCodeConverter.class})
@Component
public class BaseErrorCodeConverter
implements ErrorCodeConverter {
    private static String[] internalServerErrorCodeArray = new String[]{ApiResultCode.DELETE_DATA_FAIL.getResultCode(), ApiResultCode.UPDATE_DATA_FAIL.getResultCode(), ApiResultCode.INSERT_DATA_FAIL.getResultCode(), ApiResultCode.BAD_SQL_GRAMMAR.getResultCode(), ApiResultCode.IMPORT_EXCEL_FAIL.getResultCode(), ApiResultCode.EXPORT_EXCEL_FAIL.getResultCode(), ApiResultCode.REFERENCE_DATA_ERROR.getResultCode(), ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode()};
    private static String[] notFoundCodeArray = new String[]{ApiResultCode.GET_DATA_NOT_EXIST.getResultCode(), ApiResultCode.API_VERSION_NOT_EXIST.getResultCode()};

    @Override
    public int convertErrorCodeToHttpStatus(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
        if (ApiResultCode.TOKEN_INVALID.getResultCode().equals(code)) {
            return HttpStatus.UNAUTHORIZED.value();
        }
        if (ApiResultCode.PERMISSION_DENIED.getResultCode().equals(code)) {
            return HttpStatus.FORBIDDEN.value();
        }
        if (this.isInternalServerErrorCode(code)) {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
        if (this.isNotFoundCode(code)) {
            return HttpStatus.NOT_FOUND.value();
        }
        return HttpStatus.BAD_REQUEST.value();
    }

    private boolean isInternalServerErrorCode(String code) {
        return Arrays.binarySearch(internalServerErrorCodeArray, code) > -1;
    }

    private boolean isNotFoundCode(String code) {
        return Arrays.binarySearch(notFoundCodeArray, code) > -1;
    }

    static {
        Arrays.sort(internalServerErrorCodeArray);
        Arrays.sort(notFoundCodeArray);
    }
}

