/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.base.util.id.IdUtils;
import com.cyberway.msf.commons.model.base.BusinessEntity;
import com.cyberway.msf.commons.model.base.BusinessEntityWithCompany;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import com.cyberway.msf.commons.model.base.BusinessEntityWithTenant;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.user.UserInfo;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MapperInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MapperInterceptor.class);
    private static final String COMPBANY_ID = "companyId";

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        int sqlType = this.getSqlType(args);
        if (sqlType == 0) {
            return invocation.proceed();
        }
        for (int i = 1; i < args.length; ++i) {
            Object arg = args[i];
            if (null == arg) {
                logger.info("arg[{}] is null, continue", (Object)i);
                continue;
            }
            if (arg instanceof Map) {
                Map map = (Map)arg;
                this.handleMap(sqlType, map);
                continue;
            }
            this.updateCommonFiled(arg, sqlType);
        }
        return invocation.proceed();
    }

    private void handleMap(int sqlType, Map<?, ?> map) {
        if (!map.isEmpty()) {
            Collection<?> list = map.values();
            Iterator<?> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                this.handleCollections(sqlType, iterator);
            }
        }
    }

    private void handleCollections(int sqlType, Iterator iterator) {
        Object obj = iterator.next();
        if (!(obj instanceof Collection)) {
            this.updateCommonFiled(obj, sqlType);
        } else {
            Collection entityList = (Collection)obj;
            if (!CollectionUtils.isEmpty((Collection)entityList)) {
                for (Object entity : entityList) {
                    this.updateCommonFiled(entity, sqlType);
                }
            }
        }
    }

    private int getSqlType(Object[] args) {
        int sqlType;
        Object arg = args[0];
        MappedStatement ms = (MappedStatement)arg;
        SqlCommandType sqlCommandType = ms.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.INSERT) {
            sqlType = 1;
        } else {
            if (sqlCommandType != SqlCommandType.UPDATE) {
                return 0;
            }
            sqlType = 2;
        }
        return sqlType;
    }

    private void updateCommonFiled(Object arg, int sqlType) {
        if (null == arg) {
            return;
        }
        Date currentDate = new Date();
        Long userId = null;
        String fullName = "";
        Long orgId = null;
        Long tenantId = null;
        Long companyId = null;
        Class<?> clazz = arg.getClass();
        UserInfo user = UserUtils.getLoggedInUser();
        if (user != null) {
            userId = (Long)user.getId();
            orgId = user.getOrgId();
            tenantId = user.getTenantId();
            fullName = user.getFullName();
            companyId = UserUtils.getCompanyId();
        } else {
            logger.warn("login user is null");
        }
        if (!BusinessEntity.class.isAssignableFrom(clazz) && EntityImpl.class.isAssignableFrom(clazz)) {
            if (1 == sqlType) {
                this.updateIdField(arg, clazz);
            }
        } else if (BusinessEntity.class.isAssignableFrom(clazz)) {
            this.updateCommonFiled(arg, "LastModified", currentDate, Date.class);
            this.updateCommonFiled(arg, "LastModifiedBy", userId, Long.class);
            this.updateCommonFiled(arg, "LastModifiedByName", fullName, String.class);
            if (1 == sqlType) {
                this.updateCommonFiled(arg, "CreatedDate", currentDate, Date.class);
                this.updateCommonFiled(arg, "CreatedBy", userId, Long.class);
                this.updateCommonFiled(arg, "CreatedByName", fullName, String.class);
                this.updateIdField(arg, clazz);
                this.updateCommonFiled(arg, "Owner", userId, Long.class);
                if (BusinessEntityWithOrganization.class.isAssignableFrom(clazz)) {
                    this.updateCommonFiled(arg, "OrgId", orgId, Long.class);
                }
                if (BusinessEntityWithTenant.class.isAssignableFrom(clazz)) {
                    this.updateCommonFiled(arg, "TenantId", tenantId, Long.class);
                }
                if (BusinessEntityWithCompany.class.isAssignableFrom(clazz)) {
                    this.updateCommonFiled(arg, "CompanyId", companyId, Long.class);
                }
            }
        }
    }

    private void updateIdField(Object arg, Class<?> argClass) {
        try {
            Method getFiled = argClass.getMethod("getId", new Class[0]);
            Method setFiled = argClass.getMethod("setId", Serializable.class);
            Object value = getFiled.invoke(arg, new Object[0]);
            if (value == null) {
                setFiled.invoke(arg, IdUtils.generateId(arg));
            }
        }
        catch (Exception e) {
            logger.error("Java\u53cd\u5c04\u8c03\u7528\u8bbe\u7f6eID\u5931\u8d25\u5931\u8d25,\u8c03\u7528\u7c7b[{}], \u9519\u8bef\u4fe1\u606f[{}]", new Object[]{argClass.getName(), e.getMessage(), e});
        }
    }

    private void updateCommonFiled(Object arg, String filedName, Object filedValue, Class<?> cla) {
        Class<?> clazz = arg.getClass();
        try {
            boolean state;
            Method getFiled = clazz.getMethod("get" + filedName, new Class[0]);
            Method setFiled = clazz.getMethod("set" + filedName, cla);
            Object value = getFiled.invoke(arg, new Object[0]);
            if (cla == Date.class) {
                state = null != filedValue;
            } else {
                boolean bl = state = (value == null || StringUtils.isBlank((CharSequence)value.toString())) && filedValue != null && StringUtils.isNotBlank((CharSequence)filedValue.toString());
            }
            if (state) {
                setFiled.invoke(arg, filedValue);
            }
        }
        catch (Exception e) {
            logger.info(String.format("Java\u53cd\u5c04\u8c03\u7528\u5931\u8d25,\u8c03\u7528\u7c7b%s\u4e2d\u6ca1\u6709 get%s\u6216 set%s\u65b9\u6cd5", clazz.getName(), filedName, filedName));
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

