/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.support.converter.LongFieldSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            LOGGER.info("Cannot parse json string to Object. Json: <" + json + ">, Object class: <" + clazz.getName() + ">.", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toList(String json, Class<T> clazz) throws IOException {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        return (List)MAPPER.readValue(json, javaType);
    }

    public static <T> T fromMap(Map<?, ?> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(JsonUtils.toJsonString(map), clazz);
        }
        catch (Exception e) {
            LOGGER.info("Cannot parse map to Object. Map: <" + map + ">, Object class: <" + clazz.getName() + ">.", (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, T> toMap(String jsonText, Class<T> clazz) throws IOException {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, clazz});
        return (Map)MAPPER.readValue(jsonText, javaType);
    }

    public static Map toMap(String jsonText) {
        return JsonUtils.fromJson(jsonText, Map.class);
    }

    public static String toJsonString(Object obj) {
        try {
            if (obj != null) {
                return MAPPER.writeValueAsString(obj);
            }
        }
        catch (Exception var) {
            LOGGER.warn("Cannot convert to json " + obj);
        }
        return "{}";
    }

    public static String toJsonStr(Object obj, boolean ignoreError) {
        block3: {
            try {
                if (obj != null) {
                    return MAPPER.writeValueAsString(obj);
                }
            }
            catch (Exception e) {
                LOGGER.debug("convert to json error for object: {}", obj, (Object)e);
                if (ignoreError) break block3;
                throw new IllegalArgumentException("convert to json error for object", e);
            }
        }
        return null;
    }

    public static String toJson(Object o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("toJson exception", (Throwable)e);
            return null;
        }
    }

    public static <T> T load(String filePath, Class<T> clazz) {
        FileInputStream is = null;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            is = new FileInputStream(new File(filePath));
        }
        catch (FileNotFoundException var4) {
            LOGGER.error(var4.getMessage());
        }
        return JsonUtils.load(is, clazz);
    }

    public static <T> T load(InputStream is, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(is, clazz);
        }
        catch (JsonParseException e) {
            LOGGER.warn("JsonParseException", (Throwable)e);
        }
        catch (JsonMappingException e1) {
            LOGGER.warn("JsonMappingException", (Throwable)e1);
        }
        catch (IOException e2) {
            LOGGER.warn("IOException", (Throwable)e2);
        }
        return null;
    }

    public static <T> T parser(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)LongFieldSerializer.instance);
        simpleModule.addSerializer(Long.class, (JsonSerializer)LongFieldSerializer.instance);
        MAPPER.registerModule((Module)simpleModule);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

