/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.model.base.FullHierarchicalEntity;
import com.cyberway.msf.commons.model.tree.ZtreeNode;
import com.cyberway.msf.commons.model.util.LongUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class TreeUtils {
    private TreeUtils() {
    }

    public static List<ZtreeNode> getTree(List<? extends FullHierarchicalEntity<?>> rootNodes, List<? extends FullHierarchicalEntity<?>> childNodes, String type) {
        ArrayList<ZtreeNode> ztreeNodes = new ArrayList<ZtreeNode>();
        if (CollectionUtils.isNotEmpty(rootNodes)) {
            HashMap map = new HashMap(childNodes.size());
            rootNodes.forEach(entity -> ztreeNodes.add(TreeUtils.generateNodes(entity, map, childNodes, type)));
        }
        return ztreeNodes;
    }

    public static List<ZtreeNode> getTree(List<? extends FullHierarchicalEntity<?>> rootNodes, List<? extends FullHierarchicalEntity<?>> childNodes) {
        return TreeUtils.getTree(rootNodes, childNodes, null);
    }

    private static ZtreeNode generateNodes(FullHierarchicalEntity<?> entity, Map<Long, Long> map, List<? extends FullHierarchicalEntity<?>> childNodes, String type) {
        ZtreeNode ztreeNode = new ZtreeNode(LongUtils.longToString((Long)entity.getId()), type, entity.getName());
        ArrayList childrenZtreeNodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(childNodes)) {
            childNodes.stream().filter(childEntity -> !map.containsKey(childEntity.getId())).filter(childEntity -> entity.getId() != null && entity.getId().equals(childEntity.getParent())).forEach(childEntity -> {
                map.put(childEntity.getId(), childEntity.getParent());
                childrenZtreeNodes.add(TreeUtils.generateNodes(childEntity, map, childNodes, type));
            });
        }
        ztreeNode.setChildren(childrenZtreeNodes);
        ztreeNode.setpId(entity.getParent() == null ? null : new BigDecimal(entity.getParent()).toPlainString());
        ztreeNode.setIsParent(Boolean.valueOf(!childrenZtreeNodes.isEmpty()));
        return ztreeNode;
    }
}

