/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.controller;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.controller.BaseHandleExceptionController;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.BusinessInfoLogUtils;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.model.base.EntityImpl;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

public class BaseVoController<T extends EntityImpl<Long>>
extends BaseHandleExceptionController {
    @Autowired
    protected BaseService<T> baseServiceImpl;

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u5b9e\u4f53")
    @DeleteMapping(value={"/{id}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", paramType="path", required=true, dataType="long", example="0")})
    public ApiResponseResult<Integer> delete(@PathVariable Long id) {
        BusinessInfoLogUtils.putBusinessInfo(this.getEntityClass(), id);
        return this.batchDelete(Collections.singletonList(id), this.baseServiceImpl);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DeleteMapping
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id", paramType="body", required=true, allowMultiple=true, dataType="long", example="0")})
    public ApiResponseResult<Integer> batchDelete(@RequestBody List<Long> ids) {
        return this.batchDelete(ids, this.baseServiceImpl);
    }

    protected ApiResponseResult<Integer> batchDelete(List<Long> ids, BaseService<T> baseService) {
        if (CollectionUtils.isEmpty(ids)) {
            throw MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids");
        }
        int sum = baseService.batchDelete(ids);
        if (sum > 0) {
            return new ApiResponseResult((Object)sum);
        }
        throw MessageUtils.buildException(ApiResultCode.DELETE_DATA_FAIL, new Object[0]);
    }

    protected Class<T> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

