/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.mapper.BaseMapper;
import com.cyberway.msf.commons.base.service.BaseCrudService;
import com.cyberway.msf.commons.base.service.BaseEntityServiceImpl;
import com.cyberway.msf.commons.base.support.multitable.MultiSqls;
import com.cyberway.msf.commons.base.support.multitable.MultiTableExample;
import com.cyberway.msf.commons.base.support.multitable.MultiTableSelectExample;
import com.cyberway.msf.commons.base.support.provider.CustomSqlHelper;
import com.cyberway.msf.commons.base.support.provider.ExampleOgnl;
import com.cyberway.msf.commons.base.util.BusinessInfoLogUtils;
import com.cyberway.msf.commons.base.util.DateUtils;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.PageUtils;
import com.cyberway.msf.commons.base.util.SqlUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.exception.BusinessPreconditions;
import com.cyberway.msf.commons.model.annotation.AssociatedTable;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.base.FullHierarchicalEntity;
import com.cyberway.msf.commons.model.filter.FieldType;
import com.cyberway.msf.commons.model.filter.Filter;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.filter.Operation;
import com.cyberway.msf.commons.model.page.Orders;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.Sqls;

public class BaseCrudServiceImpl<T extends EntityImpl<K>, K extends Serializable>
extends BaseEntityServiceImpl
implements BaseCrudService<T, K> {
    private static final String[] TENANT_PROPERTIES = new String[]{"id", "createdBy", "createdByName", "createdDate", "lastModifiedBy", "lastModifiedByName", "lastModified", "owner", "systemLastModified", "tenantId", "orgId"};
    @Autowired
    protected BaseMapper<T> baseMapper;

    @Override
    public T selectById(K primaryKey) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            return this.multiTableSelectByPrimaryKey(primaryKey, columnSet, entityClass);
        }
        return (T)((EntityImpl)this.baseMapper.selectByPrimaryKey(primaryKey));
    }

    private T multiTableSelectByPrimaryKey(Object primaryKey, Set<EntityColumn> columnSet, Class<T> entityClass) {
        MultiTableSelectExample example = new MultiTableSelectExample(entityClass);
        this.generateAssociation(columnSet, example);
        example.addPrimaryKey(primaryKey);
        return (T)((EntityImpl)this.baseMapper.multiTableSelectByPrimaryKey(example));
    }

    private void generateAssociation(Set<EntityColumn> columnSet, MultiTableSelectExample example) {
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            AssociatedTable associatedTable = (AssociatedTable)entityColumn.getEntityField().getAnnotation(AssociatedTable.class);
            Set associatedColumnSet = EntityHelper.getPKColumns((Class)associatedTable.associatedClass());
            example.addLeftJoin(MultiSqls.custom().leftJoin(EntityHelper.getEntityTable((Class)associatedTable.associatedClass()).getName(), associatedTable.mappingField()).on(entityColumn.getEntityField().isAnnotationPresent(Column.class) ? ((Column)entityColumn.getEntityField().getAnnotation(Column.class)).name() : entityColumn.getEntityField().getName(), ((EntityColumn)associatedColumnSet.iterator().next()).getEntityField().getName()));
            example.selectAssociatedProperty(associatedTable.mappingField(), associatedTable.associatedField(), associatedTable.mappingField());
        }
    }

    @Override
    public List<T> selectAll() {
        return this.baseMapper.selectAll();
    }

    @Override
    public List<T> selectByExample(Object example) {
        return this.baseMapper.selectByExample(example);
    }

    private List<T> selectByFilters(FilterModel filterModel, boolean doPage) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        boolean multiFlag = false;
        Set columnSet = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn entityColumn : columnSet) {
            if (!entityColumn.getEntityField().isAnnotationPresent(AssociatedTable.class)) continue;
            multiFlag = true;
            break;
        }
        try {
            MultiTableSelectExample example;
            if (multiFlag) {
                example = new MultiTableSelectExample(entityClass);
                this.generaExample(example, filterModel, columnSet, entityClass);
                if (doPage) {
                    String orderBy = this.generaOrderBy(filterModel, example, entityClass);
                    PageUtils.sortAndPagination((PageModel)filterModel, orderBy);
                }
                return this.baseMapper.multiTableSelectByExample(example);
            }
            if (doPage) {
                PageUtils.sortAndPagination((PageModel)filterModel);
            }
            example = new Example(entityClass);
            this.generaExample(example, filterModel);
            return this.selectByExample(example);
        }
        catch (MapperException e) {
            throw MessageUtils.buildException(ApiResultCode.QUERY_DATA_FAIL, e.getMessage());
        }
    }

    @Override
    public List<T> selectByFilters(FilterModel filterModel) {
        return this.selectByFilters(filterModel, false);
    }

    @Override
    public PageDataModel<T> selectByFiltersPaging(FilterModel filterModel) {
        return PageUtils.getPageDataModel((PageModel)filterModel, this.selectByFilters(filterModel, true));
    }

    private String generaOrderBy(FilterModel filterModel, MultiTableSelectExample example, Class<T> entityClass) {
        if (filterModel == null) {
            return "";
        }
        List orders = filterModel.getOrders();
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return "";
        }
        StringBuilder orderBy = new StringBuilder();
        for (Orders order : orders) {
            String sort;
            String prefix;
            if (StringUtils.isEmpty((CharSequence)order.getSort()) || StringUtils.isEmpty((CharSequence)order.getOrder())) continue;
            PageUtils.sqlValidate(order.getSort(), order.getOrder());
            String string = prefix = StringUtils.indexOf((CharSequence)order.getSort(), (CharSequence)".") < 0 ? "" : StringUtils.substringBefore((String)order.getSort(), (String)".");
            if (StringUtils.isNotEmpty((CharSequence)prefix) && !CustomSqlHelper.getDefaultAlias(entityClass).trim().equals(prefix)) {
                sort = order.getSort();
                orderBy.append(sort).append(' ').append(order.getOrder()).append(",");
                continue;
            }
            sort = StringUtils.substring((String)order.getSort(), (int)(StringUtils.indexOf((CharSequence)order.getSort(), (CharSequence)".") + 1));
            orderBy.append(ExampleOgnl.getTableAlias(example)).append(".").append(sort).append(' ').append(order.getOrder()).append(",");
        }
        return StringUtils.removeEnd((String)orderBy.toString(), (String)",");
    }

    protected void generaExample(Example example, FilterModel filterModel) {
        if (filterModel == null || CollectionUtils.isEmpty((Collection)filterModel.getFilters())) {
            return;
        }
        Example.Criteria criteria = example.createCriteria();
        for (Filter filter : filterModel.getFilters()) {
            Operation operation = filter.getOperation();
            String field = StringUtils.substring((String)filter.getField(), (int)(StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") + 1));
            this.getFilterExample(filter, operation, field, criteria);
        }
        if (CollectionUtils.isEmpty((Collection)criteria.getCriteria())) {
            example.getOredCriteria().remove(criteria);
        }
    }

    protected void generaExample(MultiTableSelectExample example, FilterModel filterModel, Set<EntityColumn> columnSet, Class<T> entityClass) {
        this.generateAssociation(columnSet, example);
        if (filterModel == null || CollectionUtils.isEmpty((Collection)filterModel.getFilters())) {
            return;
        }
        Example.Criteria exampleCriteria = example.createCriteria();
        MultiTableExample.MultiTableCriteria multiTableCriteria = example.createMultiTableCriteria();
        example.and(multiTableCriteria);
        for (Filter filter : filterModel.getFilters()) {
            String field;
            String prefix;
            Operation operation = filter.getOperation();
            String string = prefix = StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") < 0 ? "" : StringUtils.substringBefore((String)filter.getField(), (String)".");
            if (StringUtils.isNotEmpty((CharSequence)prefix) && !CustomSqlHelper.getDefaultAlias(entityClass).trim().equals(prefix)) {
                field = filter.getField();
                this.getFilterExample(filter, operation, field, multiTableCriteria);
                continue;
            }
            field = StringUtils.substring((String)filter.getField(), (int)(StringUtils.indexOf((CharSequence)filter.getField(), (CharSequence)".") + 1));
            this.getFilterExample(filter, operation, field, exampleCriteria);
        }
        if (CollectionUtils.isEmpty((Collection)exampleCriteria.getCriteria())) {
            example.getOredCriteria().remove(exampleCriteria);
        }
        if (CollectionUtils.isEmpty((Collection)multiTableCriteria.getCriteria())) {
            example.getOredCriteria().remove((Object)multiTableCriteria);
        }
    }

    private void getFilterExample(Filter filter, Operation operation, String field, Example.Criteria criteria) {
        Object value = filter.getValue();
        if (value == null) {
            return;
        }
        if (FieldType.String.equals((Object)filter.getFieldType())) {
            if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
                return;
            }
            if (value instanceof List && CollectionUtils.isEmpty((Collection)((List)value))) {
                return;
            }
        }
        if (FieldType.Date.equals((Object)filter.getFieldType()) || FieldType.DateTime.equals((Object)filter.getFieldType())) {
            Calendar calendar = Calendar.getInstance();
            Date time = value instanceof Date ? (Date)value : DateUtils.parseDate(value);
            if (time == null) {
                throw MessageUtils.buildException(ApiResultCode.REQUIRE_PARAM_IS_ERROR, new Object[0]);
            }
            calendar.setTime(time);
            if (FieldType.Date.equals((Object)filter.getFieldType())) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (Operation.GreaterThan.equals((Object)operation) || Operation.GreaterThanEq.equals((Object)operation)) {
                value = calendar.getTime();
            }
            if (Operation.LessThan.equals((Object)operation) || Operation.LessThanEq.equals((Object)operation)) {
                if (FieldType.Date.equals((Object)filter.getFieldType()) && Operation.LessThanEq.equals((Object)operation)) {
                    calendar.add(5, 1);
                    calendar.add(14, -1);
                }
                value = calendar.getTime();
            }
        }
        this.handlerOperator(filter, operation, field, criteria, value);
    }

    private void handlerOperator(Filter filter, Operation operation, String field, Example.Criteria criteria, Object value) {
        switch (operation) {
            case Eq: {
                criteria.andEqualTo(field, value);
                break;
            }
            case NotEq: {
                criteria.andNotEqualTo(field, value);
                break;
            }
            case StartsWith: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchStart((String)value));
                break;
            }
            case EndsWith: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchEnd((String)value));
                break;
            }
            case Contains: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andLike(field, SqlUtils.matchAnywhere((String)value));
                break;
            }
            case NotContains: {
                if (!FieldType.String.equals((Object)filter.getFieldType())) break;
                criteria.andNotLike(field, SqlUtils.matchAnywhere((String)value));
                break;
            }
            case LessThan: {
                criteria.andLessThan(field, value);
                break;
            }
            case GreaterThan: {
                criteria.andGreaterThan(field, value);
                break;
            }
            case LessThanEq: {
                criteria.andLessThanOrEqualTo(field, value);
                break;
            }
            case GreaterThanEq: {
                criteria.andGreaterThanOrEqualTo(field, value);
                break;
            }
            case InList: {
                if (!(value instanceof Iterable)) break;
                criteria.andIn(field, (Iterable)value);
                break;
            }
            case NotInList: {
                if (!(value instanceof Iterable)) break;
                criteria.andNotIn(field, (Iterable)value);
                break;
            }
            case IsNull: {
                criteria.andIsNull(field);
                break;
            }
            case IsNotNull: {
                criteria.andIsNotNull(field);
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateSelective(T entity) {
        return this.updateSelective(entity, "updateSelective");
    }

    private int updateSelective(T entity, String methodName) {
        this.validateData(entity, methodName);
        this.beforeSave(entity, methodName);
        T oldFullHierarchicalEntity = this.getOldFullHierarchicalEntity(entity);
        this.getFullHierarchicalEntity(entity);
        int result = this.baseMapper.updateByPrimaryKeySelective(entity);
        if (result > 0) {
            this.afterSave(entity, methodName);
            this.updateFullHierarchicalEntityCascade(oldFullHierarchicalEntity, entity);
        }
        return result;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public int update(T entity) {
        return this.updateSelective(entity, "update");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateAll(T entity) {
        String methodName = "updateAll";
        this.validateData(entity, "updateAll");
        this.beforeSave(entity, "updateAll");
        T oldFullHierarchicalEntity = this.getOldFullHierarchicalEntity(entity);
        this.getFullHierarchicalEntity(entity);
        EntityImpl.class.isAssignableFrom(entity.getClass());
        T old = this.selectById(entity.getId());
        BeanUtils.copyProperties(entity, old, (String[])TENANT_PROPERTIES);
        entity = old;
        int result = this.baseMapper.updateByPrimaryKey(entity);
        if (result > 0) {
            this.afterSave(entity, "updateAll");
            this.updateFullHierarchicalEntityCascade(oldFullHierarchicalEntity, entity);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insert(T entity) {
        String methodName = "insert";
        this.validateData(entity, "insert");
        this.beforeSave(entity, "insert");
        if (entity.getId() != null) {
            BusinessInfoLogUtils.putBusinessInfo(entity.getClass(), entity.getId().toString());
        }
        this.getFullHierarchicalEntity(entity);
        int result = this.baseMapper.insertSelective(entity);
        if (entity.getId() != null) {
            BusinessInfoLogUtils.putBusinessInfo(entity.getClass(), entity.getId().toString());
        }
        if (result > 0) {
            this.afterSave(entity, "insert");
        }
        return result;
    }

    @Override
    public Boolean containsByEntity(T entity) {
        return this.baseMapper.selectCount(entity) > 0;
    }

    @Override
    public Boolean contains(Object example) {
        return this.baseMapper.selectCountByExample(example) > 0;
    }

    protected void validateData(T entity) {
    }

    protected void validateData(T entity, String methodName) {
        this.validateData(entity);
    }

    protected void beforeSave(T entity) {
    }

    protected void beforeSave(T entity, String methodName) {
        this.beforeSave(entity);
    }

    protected void afterSave(T entity) {
    }

    protected void afterSave(T entity, String methodName) {
        this.afterSave(entity);
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<K> entity, String property, Object value, ApiResultCode exceptionResultCode) {
        this.validateUnique(clazz, entity, property, value, exceptionResultCode, false);
    }

    protected void validateUnique(EntityImpl<K> entity, String property, Object value, ApiResultCode exceptionResultCode) {
        this.validateUnique(entity, property, value, exceptionResultCode, false);
    }

    protected void validateUnique(Class<?> clazz, EntityImpl<K> entity, String property, Object value, ApiResultCode exceptionResultCode, Boolean ignoreDeleted) {
        if (value == null) {
            return;
        }
        Sqls sqls = Sqls.custom().andEqualTo(property, value);
        if (entity.getId() != null) {
            sqls.andNotEqualTo("id", (Object)entity.getId());
        }
        if (!Boolean.TRUE.equals(ignoreDeleted)) {
            sqls.andEqualTo("deleted", (Object)Boolean.FALSE);
        }
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, value);
        }
    }

    protected void validateUnique(EntityImpl<K> entity, String property, Object value, ApiResultCode exceptionResultCode, Boolean ignoreDeleted) {
        this.validateUnique(entity.getClass(), entity, property, value, exceptionResultCode, ignoreDeleted);
    }

    protected void validateBySqls(Class<?> clazz, Sqls sqls, ApiResultCode exceptionResultCode, Object ... errorArgs) {
        if (CollectionUtils.isNotEmpty(this.selectByExample(Example.builder(clazz).where(sqls).build()))) {
            throw MessageUtils.buildException(exceptionResultCode, errorArgs);
        }
    }

    private T getOldFullHierarchicalEntity(T entity) {
        return FullHierarchicalEntity.class.isAssignableFrom(entity.getClass()) ? (T)this.selectById(entity.getId()) : null;
    }

    private void getFullHierarchicalEntity(T entity) {
        if (entity instanceof FullHierarchicalEntity) {
            FullHierarchicalEntity fullHierarchicalEntity = (FullHierarchicalEntity)entity;
            Long parent = fullHierarchicalEntity.getParent();
            if (parent == null) {
                fullHierarchicalEntity.setAllParent("");
                fullHierarchicalEntity.setFullPathName(fullHierarchicalEntity.getName());
                return;
            }
            FullHierarchicalEntity parentEntity = (FullHierarchicalEntity)this.selectById(parent);
            if (null == parentEntity) {
                fullHierarchicalEntity.setAllParent("");
                fullHierarchicalEntity.setFullPathName(fullHierarchicalEntity.getName());
                return;
            }
            fullHierarchicalEntity.setAllParent(" " + parent + (String)StringUtils.defaultIfBlank((CharSequence)parentEntity.getAllParent(), (CharSequence)" "));
            String parentFullPathName = StringUtils.isBlank((CharSequence)parentEntity.getFullPathName()) ? "" : parentEntity.getFullPathName() + '/';
            fullHierarchicalEntity.setFullPathName(parentFullPathName + fullHierarchicalEntity.getName());
        }
    }

    protected void updateFullHierarchicalEntityCascade(T oldEntity, T entity) {
        if (oldEntity instanceof FullHierarchicalEntity) {
            FullHierarchicalEntity oldFullHierarchicalEntity = (FullHierarchicalEntity)oldEntity;
            FullHierarchicalEntity fullHierarchicalEntity = (FullHierarchicalEntity)entity;
            if (!StringUtils.equals((CharSequence)StringUtils.defaultString((String)oldFullHierarchicalEntity.getAllParent()), (CharSequence)StringUtils.defaultString((String)fullHierarchicalEntity.getAllParent())) || !StringUtils.equals((CharSequence)oldFullHierarchicalEntity.getName(), (CharSequence)fullHierarchicalEntity.getName())) {
                Example example = new Example(entity.getClass());
                example.selectProperties(new String[]{"id", "name", "parent", "allParent", "fullPathName", "sortNo"});
                example.createCriteria().andLike("allParent", SqlUtils.matchAnywhere(" " + fullHierarchicalEntity.getId() + " "));
                List allChildList = this.baseMapper.selectByExample(example);
                Map allChild = allChildList.stream().map(t -> (FullHierarchicalEntity)t).collect(Collectors.groupingBy(FullHierarchicalEntity::getParent, LinkedHashMap::new, Collectors.toList()));
                this.visitFullHierarchicalEntityChildren(fullHierarchicalEntity, allChild);
            }
        }
    }

    private void visitFullHierarchicalEntityChildren(FullHierarchicalEntity<?> parentEntity, Map<Long, List<FullHierarchicalEntity<?>>> allChild) {
        List list = Optional.ofNullable(allChild.get(parentEntity.getId())).orElse(Collections.emptyList());
        for (FullHierarchicalEntity child : list) {
            child.setAllParent(" " + child.getParent() + (String)StringUtils.defaultIfBlank((CharSequence)parentEntity.getAllParent(), (CharSequence)" "));
            String parentFullPathName = StringUtils.isBlank((CharSequence)parentEntity.getFullPathName()) ? "" : parentEntity.getFullPathName() + '/';
            child.setFullPathName(parentFullPathName + child.getName());
            this.baseMapper.updateByPrimaryKeySelective((EntityImpl)child);
            this.visitFullHierarchicalEntityChildren(child, allChild);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(K primaryKey) {
        try {
            this.beforeDelete(primaryKey);
            int sum = this.baseMapper.deleteByPrimaryKey(primaryKey);
            if (sum > 0) {
                this.afterDelete(primaryKey);
            }
            return sum;
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<K> primaryKeys) {
        BusinessPreconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(primaryKeys), (BaseException)MessageUtils.buildException(ApiResultCode.PARAM_IS_NULL, "ids"));
        try {
            List primaryKeysWithoutBlank = primaryKeys.stream().filter(key -> {
                if (key instanceof String) {
                    return StringUtils.isNotBlank((CharSequence)((String)((Object)key)));
                }
                return ObjectUtils.isNotEmpty((Object)key);
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(primaryKeysWithoutBlank)) {
                return 0;
            }
            this.beforeBatchDelete(primaryKeys);
            int sum = this.baseMapper.logicDeleteByIds(StringUtils.join((Iterable)primaryKeysWithoutBlank.stream().map(key -> {
                if (key instanceof String) {
                    return StringUtils.wrap((String)((String)((Object)key)), (String)"'");
                }
                return key;
            }).collect(Collectors.toList()), (String)","));
            if (sum > 0) {
                this.afterBatchDelete(primaryKeys);
            }
            return sum;
        }
        catch (DataIntegrityViolationException e) {
            throw new BaseException(ApiResultCode.DELETE_FAIL_REFERENCE.getResultCode(), ApiResultCode.DELETE_FAIL_REFERENCE.getResultMessage());
        }
    }

    protected void beforeDelete(K primaryKey) {
    }

    protected void beforeBatchDelete(List<K> primaryKeys) {
    }

    protected void afterDelete(K primaryKey) {
    }

    protected void afterBatchDelete(List<K> primaryKeys) {
    }
}

