/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.util.BusinessInfoLogUtils;
import feign.RequestInterceptor;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.OncePerRequestFilter;

public class BusinessInfoLogConfig {
    @Bean
    public RequestInterceptor businessInfoLogRequestInterceptor() {
        return template -> {
            template.removeHeader("Log-Business-Id").removeHeader("Log-Business-Class-Name");
            String businessId = BusinessInfoLogUtils.getBusinessId();
            String businessClassName = BusinessInfoLogUtils.getBusinessClassName();
            if (businessClassName == null && businessId == null) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)businessClassName)) {
                template.header("Log-Business-Class-Name", new String[]{businessClassName});
            }
            if (StringUtils.isNotBlank((CharSequence)businessId)) {
                template.header("Log-Business-Id", new String[]{businessId});
            }
        };
    }

    @Bean
    public Filter businessInfoLogRequestFilter() {
        return new OncePerRequestFilter(){

            protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
                String businessClassName = request.getHeader("Log-Business-Class-Name");
                String businessId = request.getHeader("Log-Business-Id");
                if (StringUtils.isNotBlank((CharSequence)businessId) || StringUtils.isNotBlank((CharSequence)businessClassName)) {
                    BusinessInfoLogUtils.putBusinessInfo(businessClassName, businessId);
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        };
    }
}

