/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.support.annotation.log.ExceptionLogContentHandler;
import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.support.annotation.log.NoLogExceptionLogContentHandler;
import com.cyberway.msf.commons.base.util.LogUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<? extends ExceptionLogContentHandler>, ExceptionLogContentHandler> exceptionLogContentHandlerMap = new LinkedHashMap<Class<? extends ExceptionLogContentHandler>, ExceptionLogContentHandler>();

    @Pointcut(value="@annotation(com.cyberway.msf.commons.base.support.annotation.log.LogRequired)")
    public void log() {
    }

    @Around(value="log() && @annotation(logRequired)")
    public Object doAround(ProceedingJoinPoint pjp, LogRequired logRequired) throws Throwable {
        Object proceed;
        String content = logRequired.content();
        String tag = (String)StringUtils.defaultIfBlank((CharSequence)logRequired.tag(), (CharSequence)logRequired.module().getCode());
        try {
            proceed = pjp.proceed();
        }
        catch (Throwable t) {
            try {
                if (!logRequired.exceptionLogContentHandler().equals(NoLogExceptionLogContentHandler.class)) {
                    String logContent;
                    boolean needLog;
                    if (!this.exceptionLogContentHandlerMap.containsKey(logRequired.exceptionLogContentHandler())) {
                        this.initExceptionLogContentHandler(logRequired.exceptionLogContentHandler());
                    }
                    boolean bl = needLog = (logContent = this.exceptionLogContentHandlerMap.get(logRequired.exceptionLogContentHandler()).buildLogContent(t, logRequired, pjp)) != null && (logRequired.logWhenContentEmpty() || StringUtils.isNotBlank((CharSequence)logContent));
                    if (needLog) {
                        LogUtils.log(logContent, tag);
                    }
                }
            }
            catch (Throwable throwable) {
                this.logger.error(throwable.getMessage(), throwable);
            }
            throw t;
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            try {
                String[] parameterNames;
                StandardEvaluationContext context = new StandardEvaluationContext();
                if (pjp.getSignature() instanceof MethodSignature && (parameterNames = ((MethodSignature)pjp.getSignature()).getParameterNames()) != null && parameterNames.length > 0) {
                    Object[] args = pjp.getArgs();
                    for (int i = 0; i < parameterNames.length; ++i) {
                        context.setVariable(parameterNames[i], args[i]);
                    }
                }
                context.setVariable(logRequired.returnValueName(), proceed);
                SpelExpressionParser parser = new SpelExpressionParser();
                Expression exp = parser.parseExpression(logRequired.content());
                Object expValue = exp.getValue((EvaluationContext)context);
                if (expValue != null && StringUtils.isNotBlank((CharSequence)expValue.toString())) {
                    LogUtils.log(expValue.toString(), tag);
                } else if (logRequired.logWhenContentEmpty()) {
                    LogUtils.log("", tag);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (logRequired.logWhenContentEmpty()) {
            LogUtils.log("", tag);
        }
        return proceed;
    }

    private synchronized void initExceptionLogContentHandler(Class<? extends ExceptionLogContentHandler> clazz) throws IllegalAccessException, InstantiationException {
        if (!this.exceptionLogContentHandlerMap.containsKey(clazz)) {
            this.exceptionLogContentHandlerMap.put(clazz, clazz.newInstance());
        }
    }
}

