/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.script.groovy;

import com.cyberway.msf.commons.base.support.script.groovy.BindingFactory;
import com.cyberway.msf.commons.base.support.script.groovy.CompoundEnhancer;
import com.cyberway.msf.commons.base.support.script.groovy.Enhancer;
import com.cyberway.msf.commons.base.support.script.mvel.MvelModel;
import groovy.lang.Binding;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.MethodInvoker;

@Component
public class BindingFactoryImpl
implements BindingFactory {
    private Enhancer enhancer = new CompoundEnhancer();

    public Enhancer getEnhancer() {
        return this.enhancer;
    }

    public void setEnhancer(Enhancer enhancer) {
        this.enhancer = enhancer;
    }

    @Override
    public Binding create(Object object) {
        return this.create(object, null);
    }

    @Override
    public Binding create(Object object, Enhancer ... enhancers) {
        Binding binding = this.newInstance(object);
        ExpandoMetaClass metaClass = new ExpandoMetaClass(Object.class);
        if (this.getEnhancer() != null) {
            this.getEnhancer().enhance(object, metaClass);
        }
        if (!ArrayUtils.isEmpty((Object[])enhancers)) {
            for (Enhancer appendEnhancer : enhancers) {
                appendEnhancer.enhance(object, metaClass);
            }
        }
        metaClass.initialize();
        binding.setMetaClass((MetaClass)metaClass);
        return binding;
    }

    protected Binding newInstance(Object object) {
        return new BindingWithRoot(object);
    }

    public static class BindingWithRoot
    extends Binding {
        private final Object root;

        public BindingWithRoot(Object root) {
            this.root = root;
        }

        public Object getProperty(String property) {
            if (this.root == null) {
                return super.getProperty(property);
            }
            try {
                return super.getProperty(property);
            }
            catch (MissingPropertyException ex) {
                try {
                    return new MvelModel(this.root, property).getObject();
                }
                catch (Exception e) {
                    return super.getProperty(property);
                }
            }
        }

        public Object invokeMethod(String name, Object args) {
            if (this.root == null) {
                return super.invokeMethod(name, args);
            }
            try {
                return super.invokeMethod(name, args);
            }
            catch (MissingMethodException ex) {
                MethodInvoker methodInvoker = new MethodInvoker();
                methodInvoker.setTargetObject(this.root);
                methodInvoker.setTargetMethod(name);
                if (args != null) {
                    if (args.getClass().isArray()) {
                        methodInvoker.setArguments((Object[])args);
                    } else {
                        methodInvoker.setArguments(new Object[]{args});
                    }
                }
                try {
                    methodInvoker.prepare();
                    return methodInvoker.invoke();
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException innerEx) {
                    throw ex;
                }
            }
        }
    }
}

