/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import org.slf4j.MDC;

public class BusinessInfoLogUtils {
    public static final String KEY_BUSINESS_CLASS_NAME = "businessClassName";
    public static final String KEY_BUSINESS_ID = "businessId";
    public static final String HEADER_BUSINESS_CLASS_NAME = "Log-Business-Class-Name";
    public static final String HEADER_BUSINESS_ID = "Log-Business-Id";

    private BusinessInfoLogUtils() {
    }

    public static void putBusinessInfo(Class<?> businessClass, Long businessId) {
        BusinessInfoLogUtils.putBusinessInfo(businessClass, businessId, false);
    }

    public static void putBusinessInfo(Class<?> businessClass, Long businessId, boolean overwriteExisted) {
        BusinessInfoLogUtils.putBusinessInfo(businessClass, businessId == null ? "" : businessId.toString(), overwriteExisted);
    }

    public static void putBusinessInfo(Class<?> businessClass, String businessId) {
        BusinessInfoLogUtils.putBusinessInfo(businessClass, businessId, false);
    }

    public static void putBusinessInfo(Class<?> businessClass, String businessId, boolean overwriteExisted) {
        BusinessInfoLogUtils.putBusinessInfo(businessClass.getName(), businessId, overwriteExisted);
    }

    public static void putBusinessInfo(String businessClassName, String businessId) {
        BusinessInfoLogUtils.putBusinessInfo(businessClassName, businessId, false);
    }

    public static void putBusinessInfo(String businessClassName, String businessId, boolean overwriteExisted) {
        if (!(overwriteExisted || BusinessInfoLogUtils.getBusinessClassName() == null && BusinessInfoLogUtils.getBusinessId() == null)) {
            return;
        }
        MDC.put((String)KEY_BUSINESS_CLASS_NAME, (String)businessClassName);
        MDC.put((String)KEY_BUSINESS_ID, (String)businessId);
    }

    public static String getBusinessClassName() {
        return MDC.get((String)KEY_BUSINESS_CLASS_NAME);
    }

    public static String getBusinessId() {
        return MDC.get((String)KEY_BUSINESS_ID);
    }
}

