/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.log;

import com.cyberway.msf.commons.base.support.annotation.log.LogRequired;
import com.cyberway.msf.commons.base.util.LogUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.cyberway.msf.commons.base.support.annotation.log.LogRequired)")
    public void log() {
    }

    @Around(value="log() && @annotation(logRequired)")
    public Object doAround(ProceedingJoinPoint pjp, LogRequired logRequired) throws Throwable {
        String content = logRequired.content();
        Object proceed = pjp.proceed();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            try {
                String[] parameterNames;
                StandardEvaluationContext context = new StandardEvaluationContext();
                if (pjp.getSignature() instanceof MethodSignature && (parameterNames = ((MethodSignature)pjp.getSignature()).getParameterNames()) != null && parameterNames.length > 0) {
                    Object[] args = pjp.getArgs();
                    for (int i = 0; i < parameterNames.length; ++i) {
                        context.setVariable(parameterNames[i], args[i]);
                    }
                }
                context.setVariable(logRequired.returnValueName(), proceed);
                SpelExpressionParser parser = new SpelExpressionParser();
                Expression exp = parser.parseExpression(logRequired.content());
                Object expValue = exp.getValue((EvaluationContext)context);
                if (expValue != null) {
                    String logContent = expValue.toString();
                    String tag = (String)StringUtils.defaultIfBlank((CharSequence)logRequired.tag(), (CharSequence)logRequired.module().getCode());
                    LogUtils.log(logContent, tag);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return proceed;
    }
}

