/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.annotation.api;

import com.cyberway.msf.commons.base.support.annotation.api.ApiOverride;
import com.cyberway.msf.commons.base.support.annotation.api.ApiOverrideCondition;
import com.cyberway.msf.commons.base.support.annotation.api.ApiVersion;
import com.cyberway.msf.commons.base.support.annotation.api.ApiVersionCondition;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        ApiVersion methodAnnotation;
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        ApiOverride overrideMethodAnnotation = (ApiOverride)AnnotationUtils.findAnnotation((Method)method, ApiOverride.class);
        if (overrideMethodAnnotation != null) {
            RequestCondition<?> methodCondition = this.getCustomMethodCondition(method);
            info = this.createApiVersionInfo(methodCondition).combine(info);
        }
        if ((methodAnnotation = (ApiVersion)AnnotationUtils.findAnnotation((Method)method, ApiVersion.class)) != null) {
            RequestCondition<?> methodCondition = this.getCustomMethodCondition(method);
            info = this.createApiVersionInfo(methodCondition).combine(info);
        } else {
            ApiVersion typeAnnotation = (ApiVersion)AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
            if (typeAnnotation != null) {
                RequestCondition<?> typeCondition = this.getCustomTypeCondition(handlerType);
                info = this.createApiVersionInfo(typeCondition).combine(info);
            }
        }
        return info;
    }

    private RequestMappingInfo createApiVersionInfo(RequestCondition<?> customCondition) {
        return new RequestMappingInfo(new PatternsRequestCondition(new String[0]), new RequestMethodsRequestCondition(new RequestMethod[0]), new ParamsRequestCondition(new String[0]), new HeadersRequestCondition(new String[0]), new ConsumesRequestCondition(new String[0]), new ProducesRequestCondition(new String[0]), customCondition);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        return ApiRequestMappingHandlerMapping.createCondition(method);
    }

    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        return ApiRequestMappingHandlerMapping.createCondition(handlerType);
    }

    private static RequestCondition<ApiVersionCondition> createCondition(Class<?> clazz) {
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation(clazz, ApiVersion.class);
        if (apiVersion == null) {
            return null;
        }
        return new ApiVersionCondition(apiVersion.value());
    }

    private static RequestCondition<?> createCondition(Method method) {
        ApiOverride apiOverride = (ApiOverride)AnnotationUtils.findAnnotation((Method)method, ApiOverride.class);
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation((Method)method, ApiVersion.class);
        if (apiVersion == null && apiOverride == null) {
            return null;
        }
        if (apiVersion != null) {
            return new ApiVersionCondition(apiVersion.value());
        }
        return new ApiOverrideCondition();
    }
}

