/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.configuration;

import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.support.configuration.SnowflakeProperties;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.base.util.id.IdGenerator;
import com.cyberway.msf.commons.base.util.id.IdUtils;
import com.cyberway.msf.commons.base.util.id.SnowflakeIdGenerator;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={CommonsBaseProperties.class, SnowflakeProperties.class})
public class CommonsBaseConfig {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;
    @Autowired
    private CommonsBaseProperties commonsBaseProperties;

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean(value={UserUtils.class})
    public UserUtils userUtils() {
        return new UserUtils();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(value={IdGenerator.class})
    @Autowired(required=false)
    public SnowflakeIdGenerator snowflakeIdGenerator(SnowflakeProperties snowflakeProperties, RedisUtils redisUtils) {
        return new SnowflakeIdGenerator(snowflakeProperties, redisUtils);
    }

    @Bean
    @ConditionalOnMissingBean(value={IdUtils.class})
    public IdUtils idUtils(IdGenerator idGenerator) {
        return new IdUtils(idGenerator);
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageUtils.class})
    @ConditionalOnBean(value={I18nUtils.class})
    public MessageUtils messageUtils(Environment environment, I18nUtils i18nUtils) {
        return new MessageUtils(environment, i18nUtils);
    }

    @PostConstruct
    public void addMapperInterceptor() {
        String dbType = (String)StringUtils.defaultIfBlank((CharSequence)this.commonsBaseProperties.getDbType(), (CharSequence)"mysql");
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().setDatabaseId(dbType);
        }
    }
}

