/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import feign.RequestInterceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignInterceptor {
    private Logger logger = LoggerFactory.getLogger(FeignInterceptor.class);

    @Bean
    public RequestInterceptor requestInterceptor() {
        return template -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        boolean multiContentLength;
                        String name = (String)headerNames.nextElement();
                        String values = request.getHeader(name);
                        boolean boundaryContentType = "Content-Type".equalsIgnoreCase(name) && values != null && values.contains("; boundary=");
                        boolean bl = multiContentLength = "Content-Length".equalsIgnoreCase(name) && template.headers().containsKey("Content-Length");
                        if (boundaryContentType || multiContentLength) continue;
                        template.header(name, new String[]{values});
                    }
                }
            } else {
                UserInfo userInfo = UserUtils.getLoggedInUser();
                if (null != userInfo) {
                    template.header("Authorization", new String[]{userInfo.getToken()});
                }
            }
        };
    }
}

