/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.base.support.annotation.log.BusinessLogEvent;
import com.cyberway.msf.commons.base.support.annotation.log.DataChangeLogEvent;
import com.cyberway.msf.commons.base.support.configuration.CommonsBaseProperties;
import com.cyberway.msf.commons.base.util.IpUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.log.model.BusinessLog;
import com.cyberway.msf.log.model.DataChangeLog;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.FrameworkEventService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    private final FrameworkEventService frameworkEventService;
    private final CommonsBaseProperties commonsBaseProperties;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static LogUtils logUtils;

    public LogUtils(FrameworkEventService frameworkEventService, CommonsBaseProperties commonsBaseProperties) {
        this.frameworkEventService = frameworkEventService;
        this.commonsBaseProperties = commonsBaseProperties;
        this.threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        this.threadPoolTaskExecutor.afterPropertiesSet();
        logUtils = this;
    }

    public static void log(String content, String tag) {
        LogUtils.log(content, tag, true);
    }

    public static void log(String content, String tag, boolean asyncSend) {
        if (logUtils == null || LogUtils.logUtils.commonsBaseProperties == null || !Boolean.TRUE.equals(LogUtils.logUtils.commonsBaseProperties.getLogEnable()) || LogUtils.logUtils.frameworkEventService == null) {
            return;
        }
        try {
            String fromIp = "";
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                fromIp = IpUtils.getRemoteAddr(request);
            }
            UserInfo userInfo = UserUtils.getLoggedInUser();
            BusinessLog log = new BusinessLog();
            log.setContent(content);
            log.setFromIp(fromIp);
            log.setCreateTime(new Date());
            log.setModule(tag);
            log.setCreateBy(userInfo == null ? null : userInfo.getUsername());
            log.setCreateById(userInfo == null ? null : (Long)userInfo.getId());
            BusinessLogEvent businessLogEvent = new BusinessLogEvent();
            businessLogEvent.setData(log);
            if (asyncSend) {
                LogUtils.logUtils.threadPoolTaskExecutor.execute(() -> LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent));
            } else {
                LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)businessLogEvent);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void logDataChange(DataChangeLog dataChangeLog) {
        if (LogUtils.logUtils.commonsBaseProperties != null && LogUtils.logUtils.commonsBaseProperties.getLogEnable().booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Log data change of table [{}], data id [{}], long data id [{}], sql type [{}]", new Object[]{dataChangeLog.getTableName(), dataChangeLog.getDataId(), dataChangeLog.getLongDataId(), dataChangeLog.getSqlType()});
            }
            DataChangeLogEvent dataChangeLogEvent = new DataChangeLogEvent();
            dataChangeLogEvent.setData(dataChangeLog);
            LogUtils.logUtils.frameworkEventService.pushEvent((FrameworkEvent)dataChangeLogEvent);
        }
    }
}

