/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.support.interceptor;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignErrorDecoder
extends ErrorDecoder.Default {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Exception decode(String methodKey, Response response) {
        try {
            Response.Body body = response.body();
            if (body != null) {
                String message = Util.toString((Reader)body.asReader(StandardCharsets.UTF_8));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Call feign method [{}] fail, status code [{}], body [{}]", new Object[]{methodKey, response.status(), message});
                }
                if (StringUtils.isNotBlank((CharSequence)message) && message.trim().startsWith("{")) {
                    return MessageUtils.buildException((ApiResponseResult)JSON.parseObject((String)message, ApiResponseResult.class), new Object[0]);
                }
            }
            return new BaseException("Call feign api error, response status code: " + response.status());
        }
        catch (IOException e) {
            this.logger.debug("Decode feign exception fail: {}", (Object)e.getMessage(), (Object)e);
            return super.decode(methodKey, response);
        }
    }
}

