/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final String DATE_FULL_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String DATE_SHORT_FORMAT_PATTERN = "yyyy-MM";
    public static final String DATETIME_FULL_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_SHORT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String TIME_FULL_FORMAT_PATTERN = "HH:mm:ss";
    public static final String TIME_SHORT_FORMAT_PATTERN = "HH:mm";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    private DateUtils() {
    }

    public static String getDate() {
        return DateUtils.getDate(DATE_FULL_FORMAT_PATTERN);
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)DATE_FULL_FORMAT_PATTERN);
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, DATETIME_FULL_FORMAT_PATTERN);
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), TIME_FULL_FORMAT_PATTERN);
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), DATETIME_FULL_FORMAT_PATTERN);
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static long pastSeconds(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 1000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (double)(afterTime - beforeTime) / 8.64E7;
    }
}

