/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.util;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.support.constant.CommonsBaseConstants;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private final Environment environment;
    private final I18nUtils i18nUtils;
    private static MessageUtils messageUtils;

    public MessageUtils(Environment environment, I18nUtils i18nUtils) {
        this.environment = environment;
        this.i18nUtils = i18nUtils;
    }

    @PostConstruct
    public void init() {
        messageUtils = this;
    }

    public static ApiResultCode buildApiResultCode(String messageKey, Object ... errorArgs) {
        String errorMessage = MessageUtils.getErrorMessage(messageKey, ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultMessage(), errorArgs);
        return new ApiResultCode(messageKey, errorMessage);
    }

    public static BaseException buildException(String messageKey, Object ... errorArgs) {
        return new BaseException(messageKey, ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultMessage(), errorArgs, null);
    }

    public static BaseException buildException(ApiResultCode apiResultCode, Object ... errorArgs) {
        return new BaseException(apiResultCode.getResultCode(), apiResultCode.getResultMessage(), errorArgs, null);
    }

    public static BaseException buildException(ApiResponseResult apiResponseResult, Object ... errorArgs) {
        return new BaseException(apiResponseResult.getResultCode(), apiResponseResult.getResultMessage(), errorArgs, null);
    }

    public static String getMessage(String messageKey) {
        String message = MessageUtils.messageUtils.environment.getProperty(messageKey);
        return StringUtils.isEmpty((CharSequence)message) ? messageKey : message;
    }

    public static String getErrorCode(String message) {
        String code = StringUtils.substringBefore((String)message, (String)":");
        if (!StringUtils.isNotBlank((CharSequence)code) || !CommonsBaseConstants.MODEL_ERROR_CODE_PATTERN.matcher(code).matches()) {
            code = ApiResultCode.UNKNOWN_SYSTEM_ERROR.getResultCode();
        }
        return code;
    }

    public static String getErrorMessage(String code, String message, Object ... errorArgs) {
        return MessageUtils.getErrorMessage(code, message, null, errorArgs);
    }

    public static String getErrorMessage(String code, String errorMessage, HttpServletRequest request, Object ... args) {
        return MessageUtils.messageUtils.i18nUtils.getMessage(code, errorMessage, request, args);
    }

    public static String getErrorMessage(ApiResultCode apiResultCode, Object ... errorArgs) {
        return StringUtils.isNotBlank((CharSequence)apiResultCode.getResultMessage()) ? MessageUtils.messageUtils.i18nUtils.getMessageWithDfaultMessage(apiResultCode.getResultCode(), apiResultCode.getResultMessage(), errorArgs) : MessageUtils.messageUtils.i18nUtils.getMessageWithArgs(apiResultCode.getResultCode(), true, errorArgs);
    }
}

