/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.base.service;

import com.cyberway.msf.commons.base.service.BaseCrudServiceImpl;
import com.cyberway.msf.commons.base.service.BaseService;
import com.cyberway.msf.commons.base.util.StringUtils;
import com.cyberway.msf.commons.cache.multi.annotation.MultiLevelCacheable;
import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.base.vo.BaseNameVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.Sqls;

public class BaseServiceImpl<T extends EntityImpl<Long>>
extends BaseCrudServiceImpl<T, Long>
implements BaseService<T> {
    @Override
    @MultiLevelCacheable(value={"data:baseNameVo"}, key="#root.target.class.name+':'+#id+'_name'", ttl=60)
    public BaseNameVo selectBaseNameVoById(Long id) {
        return this.selectBaseNameVoById(id, "name");
    }

    @Override
    @MultiLevelCacheable(value={"data:baseNameVo"}, key="#root.target.class.name+':'+#id+'_'+#field", ttl=60)
    public BaseNameVo selectBaseNameVoById(Long id, String field) {
        return this.selectBaseNameVoByIds(Arrays.asList(id), field).stream().findFirst().orElse(null);
    }

    private EntityColumn resolveNameColumn(Class<T> entityClass, String field) {
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn nameFieldCol = columnSet.stream().filter(entityColumn -> field.equals(entityColumn.getColumn())).findFirst().orElse(null);
        return nameFieldCol;
    }

    @Override
    public List<BaseNameVo> selectBaseNameVoByIds(List<Long> ids) {
        return this.selectBaseNameVoByIds(ids, "name");
    }

    @Override
    public List<BaseNameVo> selectBaseNameVoByIds(List<Long> ids, String field) {
        ArrayList<BaseNameVo> resultList = new ArrayList<BaseNameVo>();
        if (CollectionUtils.isNotEmpty(ids)) {
            String nameFiled = (String)StringUtils.defaultIfEmpty((CharSequence)field, (CharSequence)"name");
            Class entityClass = this.getEntityClass();
            EntityColumn nameFieldCol = this.resolveNameColumn(entityClass, nameFiled);
            if (nameFieldCol != null) {
                String property = nameFieldCol.getProperty();
                String getMethod = "get" + StringUtils.capitalize((String)property);
                Example example = Example.builder(entityClass).select(new String[]{"id", property}).where(Sqls.custom().andIn("id", ids)).build();
                List entities = this.baseMapper.selectByExample(example);
                for (EntityImpl entity : entities) {
                    try {
                        Object value = MethodUtils.invokeMethod((Object)entity, (String)getMethod);
                        BaseNameVo vo = new BaseNameVo();
                        vo.setId((Long)entity.getId());
                        vo.setName(Objects.toString(value, null));
                        resultList.add(vo);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return resultList;
    }
}

